<?php
/**
 * UserRegistrationAdvancedFields Frontend.
 *
 * @class    URAF_Frontend
 * @version  1.0.0
 * @package  UserRegistrationAdvancedFields/Admin
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URWC_Frontend Class
 */
class URAF_Frontend {

	public function __construct() {
		add_filter( 'user_registration_registered_form_fields', array( $this, 'get_all_registered_fields' ), 10, 1 );
		add_action( 'wp_enqueue_scripts', array( $this, 'load_scripts' ) );
		add_filter( 'user_registration_form_field_section_title', array( $this, 'user_registration_form_field_render' ), 10, 4 );
		add_filter( 'user_registration_form_field_html', array( $this, 'user_registration_form_field_render' ), 10, 4 );
		add_filter( 'user_registration_form_field_wysiwyg', array( $this, 'user_registration_form_field_render' ), 10, 4 );
		add_filter( 'user_registration_form_field_phone', array( $this, 'user_registration_form_field_render' ), 10, 4 );
	}

	/**
	 * Hook Advanced fields to core fields
	 * @param  array $fields
	 * @return array
	 */
	public function get_all_registered_fields( $fields ) {
		return array_merge( $fields, user_registration_list_advanced_fields() );
	}

	public function load_scripts() {

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		wp_register_script( 'user-registration-time-picker', URAF()->plugin_url() . '/assets/js/jquery-timepicker/jquery.timepicker' . $suffix . '.js', array( 'jquery' ), URAF_VERSION );
		wp_register_script( 'user-registration-advanced-fields-frontend', URAF()->plugin_url() . '/assets/js/frontend/uraf-frontend' . $suffix . '.js', array( 'jquery', 'user-registration-time-picker' ), URAF_VERSION );

		wp_register_style( 'user-registration-advanced-fields-time-picker-style', URAF()->plugin_url() . '/assets/css/jquery-timepicker/jquery.timepicker.css', array(), URAF_VERSION );

		wp_enqueue_script( 'user-registration-time-picker' );
		wp_enqueue_script( 'user-registration-advanced-fields-frontend' );
		wp_enqueue_style( 'user-registration-advanced-fields-time-picker-style' );
	}

	/**
	 * Render the advanced fields on frontend
	 * @param  [type] $field [description]
	 * @param  [type] $key   [description]
	 * @param  [type] $args  [description]
	 * @param  [type] $value [description]
	 * @return [type]        [description]
	 */
	public function user_registration_form_field_render( $field, $key, $args, $value ) {

		/* Conditional Logic codes */
			$rules = array();
			$rules['conditional_rules'] = isset ( $args['conditional_rules'] ) ? $args['conditional_rules'] : '';
			$rules['logic_gate'] = isset( $args['logic_gate'] ) ? $args['logic_gate'] : '';
			$rules['rules'] = isset( $args['rules'] ) ? $args['rules'] : array();
			$rules['required'] = isset( $args['required'] ) ? $args['required'] : '';
			
			foreach( $rules['rules'] as $rules_key => $rule ) {
				if( empty( $rule['field'] ) ) {
					unset( $rules['rules'][ $rules_key ] );
				}
			}
			$rules['rules'] = array_values( $rules['rules'] );

			$rules = ( ! empty( $rules['rules'] ) && isset( $args['enable_conditional_logic'] ) ) ? wp_json_encode( $rules ) : "''";
		/*Conditonal Logic codes end*/

		if ( true === $args['required'] ) {
			$args['class'][] = 'validate-required';
			$required        = ' <abbr class="required" title="' . esc_attr__( 'required', 'user-registration-advanced-fields' ) . '">*</abbr>';
		} else {
			$args['required'] = $required = '';
		}
		$description = '<span class="description">' . isset( $args['description'] ) ? $args['description'] : '' . '</span>';
		$field_content = $field_label = '';

		$field_wrapper = '<p class="form-row " id="' .esc_attr( $args['id'] ). '" data-priority="">';

		if ( $args['label'] ) {

			$field_label .= '<label for="' . esc_attr( $args['label'] ) . '">' . wp_kses( $args['label'], array(
					'a'    => array(
						'href'  => array(),
						'title' => array()
					),
					'span' => array()
				) ) . $required . '</label>';
		}
		
		switch ( $args['type'] ) {
			case 'section_title':
				if ( $args['label'] ) {
					$field_content .= '<h3 id="'.esc_attr( $args['id'] ) .'">'.esc_html( $args['label'] ) .'</h3>';
					$field_content .= $description;
					$field_content .= ' <input type="hidden" data-rules=' . $rules . '  data-id="' . esc_attr( $key ) . '" value="' . $args['default'] . '" class=" ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="'. esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" /> ';
				}
				break;
			case 'html':
				if( isset( $args['html'] ) ) {
					$field_content .= $field_wrapper.$field_label;
					$field_content .= $description;
					$field_content .= ' <input type="hidden" data-rules=' . $rules . '  data-id="' . esc_attr( $key ) . '" value="' . $args['default'] . '" class=" ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="'. esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" /> ';
					$field_content .= '<span id="'.esc_attr( $args['id'] ) .'">'. $args['html'] .'</span></p>';
				}
				break;
			case 'wysiwyg':
				$field_content .= '<p>' .$field_label. '</p>';
				$field_content .= $description;
				$field_content .= ' <input type="hidden" data-rules=' . $rules . '  data-id="' . esc_attr( $key ) . '" value="' . $args['default'] . '" class=" ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="" id="" /> ';
				$field_content .= uraf_get_wp_editor( $args );
				break;
			case 'phone':
				$field_content .= '<p>' .$field_label. '</p>';
				$field_content .= $description;
				$input_mask = isset( $args['input_mask'] ) ? $args['input_mask'] : '(999) 999-9999';
				$field_content .= ' <input data-rules=' . $rules . ' data-inputmask="\'mask\':\''. $input_mask .'\'" data-id="' . esc_attr( $key ) . '" type="text" value="' . $args['default'] . '" class=" ' . esc_attr( implode( ' ', $args['input_class'] ) ) . 'ur-masked-input" name="'. esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" /> ';
				break;
		}
		

		echo $field_content;

		return '';

	}

}

return new URAF_Frontend();