<?php

/**
 * @param $path
 *
 * @return string
 */
function user_registration_list_advanced_fields() {
		return
		apply_filters( 'user_registration_advanced_fields',
			array(
				'section_title',
				'html',
				'timepicker',
				'phone',
				'wysiwyg'
			)
		);
}

function uraf_is_compatible() {

	$plugins_path = WP_PLUGIN_DIR . URAF_DS . 'user-registration' . URAF_DS . 'user-registration.php';

	if ( ! file_exists( $plugins_path ) ) {

		return __( 'Please install <code>user-registration</code> plugin to use <code>user-registration-advanced_fields</code> addon.', 'user-registration-advanced-fields' );
	}

	$plugin_file_path = 'user-registration/user-registration.php';

	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	if ( ! is_plugin_active( $plugin_file_path ) ) {

		return __( 'Please activate <code>user-registration</code> plugin to use <code>user-registration-advanced_fields</code> addon.', 'user-registration-advanced-fields' );

	}

	if ( function_exists( 'UR' ) ) {

		$user_registration_version = UR()->version;

	} else {

		$user_registration_version = get_option( 'user_registration_version' );

	}

	if ( version_compare( $user_registration_version, '1.4.1', '<' ) ) {

		return __( 'Please update your <code>user registration</code> plugin to at least 1.4.1 version to use <code>user-registration-advanced-fields</code> addon.', 'user-registration-advanced-fields' );

	}

	return 'YES';

}

function uraf_check_plugin_compatibility() {
	add_action( 'admin_notices', 'uraf_admin_notices', 10 );
}

function uraf_admin_notices() {

	$class = 'notice notice-error';
	$message = uraf_is_compatible();

	if ( 'YES' !== $message ) {
		printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), ( $message ) );
	}
}

add_filter( 'user_registration_field_keys', 'uraf_advanced_field_keys', 10, 2 );
/**
 * Hook into core to render advanced fields
 * @param  string $field_type
 * @param  string $field_key
 * @return string
 */
function uraf_advanced_field_keys( $field_type, $field_key ) {
	switch( $field_key ) {
		case 'section_title':
			$field_type = 'section_title';
			break;
		case 'html':
			$field_type = 'html';
			break;
		case 'wysiwyg':
			$field_type = 'wysiwyg';
			break;
		case 'timepicker':
			$field_type = 'timepicker';
			break;
		case 'phone':
			$field_type = 'phone';
			break;
	}

	return $field_type;
}

function uraf_get_wp_editor( $args ) {
		$value = isset( $args['value'] ) ? $args['value'] : '';
		$settings = array(
			'media_buttons' => false,
			'editor_class'  => 'wysiwyg input-text ur-frontend-field'
		);
		ob_start();
		wp_editor( $value, $args['id'], $settings );
		return ob_get_clean();
}

add_filter( 'user_registration_sanitize_field', 'uraf_sanitize_fields', 10, 2 );
/**
 * Sanitize advanced fields on frontend submit
 * @param  array $form_data
 * @param  string $field_key
 * @return array
 */
function uraf_sanitize_fields( $form_data, $field_key ) {
	switch ( $field_key ) {
		case 'wysiwyg':
			$form_data->value = wp_kses_post( $form_data->value );
			break;
		case 'phone':
			$form_data->value = sanitize_text_field( $form_data->value );
			break;
		case 'timepicker':
			$form_data->value = sanitize_text_field( $form_data->value );
			break;
		case 'section_divider':
		case 'html':
			$form_data->value = sanitize_text_field( $form_data->value );
			break;
	}
	return $form_data;
}

add_filter( 'user_registration_profile_account_filter_html', 'profile_fields_data', 10, 1 );

/**
 * Hook field type for access in profile page
 * @param  mixed $filter_data
 * @return mixed
 */
function profile_fields_data( $filter_data) {
	$field		=  $filter_data['field'];
	$field_name 	= isset( $field->general_setting->field_name ) ? $field->general_setting->field_name : '';
	$field_index 	= 'user_registration_' . $field_name;
	$field_key 		= isset( $field->field_key ) ? $field->field_key : '';
	
	if( $field_key == 'html' ){
		$field_index 	= $field_name;
		$field_key 		= isset( $field->field_key ) ? $field->field_key : '';
		$filter_data[ 'fields' ][ $field_index ]['type']  = 'html';
		$filter_data[ 'fields' ][ $field_index ]['html']  = isset( $field->general_setting->html ) ? $field->general_setting->html : '';
		$filter_data[ 'fields' ][ $field_index ]['label']  = isset( $field->general_setting->label ) ? $field->general_setting->label : '';
		$filter_data[ 'fields' ][ $field_index ]['description']  = isset( $field->general_setting->description ) ? $field->general_setting->description : '';	
	}

	return $filter_data;
}

add_filter( 'user_registration_before_register_user_filter', 'strip_title_html_data_save', 10, 2 );

/**
 * Strip title and html section to save in usermeta
 * @param  object $valid_form_data
 * @param  int $form_id 
 * @return object
 */
function strip_title_html_data_save( $valid_form_data, $form_id ) {
	$strip_fields = array( 'section_title', 'html' );
	foreach( $valid_form_data as $key => $form_data ) {
		if( isset( $form_data->extra_params['field_key'] ) &&  in_array( $form_data->extra_params['field_key'], $strip_fields) ) {
			unset( $valid_form_data[ $key ] );
		}
	}

	return $valid_form_data;
}