<?php
/**
 * UserRegistrationSocialConnect Admin.
 *
 * @class    URSC_Admin
 * @version  1.0.0
 * @package  UserRegistrationSocialConnect/Admin
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URSC_Admin Class
 */
class URSC_Admin {

	/**
	 * Hook in tabs.
	 */
	public function __construct() {

		ursc_check_plugin_compatibility();
		$message = ursc_is_compatible();
		if ( $message !== 'YES' ) {
			return;
		}

		add_filter( 'user_registration_get_settings_pages', array( $this, 'add_social_connect' ), 10, 1 );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_styles' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		add_action( 'admin_init', array( $this, 'admin_redirects' ) );


	}

	/**
	 * Handle redirects to setup/welcome page after install and updates.
	 *
	 * For setup wizard, transient must be present, the user must have access rights, and we must ignore the network/bulk plugin updaters.
	 */
	public function admin_redirects() {
		// Setup wizard redirect
		if ( get_transient( '_ursc_activation_redirect' ) ) {
			delete_transient( '_ursc_activation_redirect' );

			if ( ( is_network_admin() || isset( $_GET['activate-multi'] ) ) || ! current_user_can( 'manage_options' ) || apply_filters( 'ursc_prevent_activation_redirect', false ) ) {
				return;
			}

			$message = ursc_is_compatible();
			if ( 'YES' == $message ) {
				// If the user needs to install, send them to the settings page.
				wp_safe_redirect( admin_url( 'admin.php?page=user-registration-settings&tab=social_connect' ) );
				exit;
			}
		}
	}

	/**
	 * @param $settings
	 *
	 * @return array
	 */
	function add_social_connect( $settings ) {

		if ( class_exists( 'UR_Settings_Page' ) ) {
			$settings[] = include( 'settings/class-ursc-settings-social.php' );
		}

		return $settings;
	}

	public function admin_scripts() {

		$screen    = get_current_screen();
		$tab       = isset( $_GET['tab'] ) ? $_GET['tab'] : '';
		$screen_id = $screen ? $screen->id : '';
		$suffix    = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
		if ( 'social_connect' === $tab && 'user-registration_page_user-registration-settings' === $screen_id ) {
			wp_register_script( 'user-registration-social-connect-admin', URSC()->plugin_url() . '/assets/js/admin/user-registration-social-connect-admin' . $suffix . '.js', array(
				'jquery',
			), URSC_VERSION );

			wp_enqueue_script( 'user-registration-social-connect-admin' );
		}


	}

	public function admin_styles() {
		$screen    = get_current_screen();
		$tab       = isset( $_GET['tab'] ) ? $_GET['tab'] : '';
		$screen_id = $screen ? $screen->id : '';
		if ( 'social_connect' === $tab && 'user-registration_page_user-registration-settings' === $screen_id ) {
			wp_register_style( 'user-registration-social-connect-admin-style', URSC()->plugin_url() . '/assets/css/user-registration-social-connect-admin-style.css', array(), URSC_VERSION );
			wp_enqueue_style( 'user-registration-social-connect-admin-style' );

		}

	}

}

return new URSC_Admin();
