<?php
/**
 * UserRegistrationSocialConnect Frontend.
 *
 * @class    URSC_Frontend
 * @version  1.0.0
 * @package  UserRegistrationSocialConnect/Admin
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URSC_Social_Data Class
 */
class URSC_Social_Data {


	/**
	 * @param $email
	 */
	public static function email_exists( $email ) {

		$exists = email_exists( $email );

		if ( $exists ) {

			return true;
		}

		return false;
	}

	/**
	 * @param $email
	 * @param $password
	 */
	public static function check_password( $email, $password ) {

		$check = wp_authenticate_email_password( null, $email, $password );

		if ( null === $check ) {

			return __( 'Could not found any user.', 'user-registration-social-connect' );
		}
		if ( is_wp_error( $check ) ) {

			return WP_Error::get_error_message( $check );
		}

		return 'success';


	}

	/**
	 * @param $network
	 * @param $user_id
	 */
	public static function is_already_connected_network( $username, $network_name, $email = '' ) {
		$meta_prefix = 'user_registration_social_connect_';
		$user_data   =
			get_users(
				array(
					'meta_key'    => $meta_prefix . $network_name . '_username',
					'meta_value'  => $username,
					'number'      => 1,
					'count_total' => false
				)

			);

		if ( ! empty( $email ) ) {

			if ( isset( $user_data[0] ) ) {

				return $user_data[0]->data->user_email === $email ? true : false;

			}

			return false;
		}


		return count( $user_data ) === 0 ? false : true;
	}

	/**
	 * @param $user_id
	 */
	public static function update_network_connection( $user_id, $network_data = array() ) {

		$network_name = $network_data['network'];
		$meta_prefix  = 'user_registration_social_connect_';
		update_user_meta( $user_id, $meta_prefix . $network_name . '_username', $network_data['username'] );
		update_user_meta( $user_id, $meta_prefix . $network_name . '_profile', $network_data['profile'] );
	}

	/**
	 * @param $network_data
	 */
	public static function check_user_and_login( $network_data ) {


		$meta_prefix = 'user_registration_social_connect_';
		$user_data   =
			get_users(
				array(
					'meta_key'    => $meta_prefix . $network_data['network'] . '_username',
					'meta_value'  => $network_data['username'],
					'number'      => 1,
					'count_total' => false
				)

			);

		$user = $user_data[0];

		$status = self::login_user( $user->ID );

		if ( is_wp_error( $status ) ) {

			return $status;
		}
		ursc_custom_redirect( admin_url() );
	}

	/**
	 * @param $user_id
	 */
	public static function login_user( $user_id ) {

		$login_option = get_option( 'user_registration_general_setting_login_options', '' );

		if ( 'admin_approval' === $login_option ) {

			$user_status = get_user_meta( $user_id, 'ur_user_status', true );

			if ( $user_status == 0 || $user_status == - 1 ) {

				$message = $user_status == 0 ? __( 'Your account is still pending approval.', 'user-registration-social-connect' ) : __( 'Your account has been denied.', 'user-registration-social-connect' );

				return new WP_Error( 'user_registration_admin_approval_prevent', $message );

			}


		}


		ursc_flush_all();
		wp_clear_auth_cookie();
		wp_set_auth_cookie( $user_id );
	}

	/**
	 * @param $userdata
	 *
	 * @return int|WP_Error
	 */
	public static function register_user( $userdata ) {

		$userdata = array(

			'user_login' => $userdata['user_login'],

			'user_pass' => $userdata['user_pass'],

			'user_email' => $userdata['user_email'],

			'role' => $userdata['role'],

		);

		$user_id = wp_insert_user( $userdata );

		return $user_id;
	}

	/**
	 * @param $email
	 * @param $username
	 * @param $network
	 * @param $profile
	 */
	public static function ursc_register_user( $email, $username, $network, $profile, $password ) {

		$user_data = array(

			'user_email' => $email,
			'user_pass'  => $password,
			'user_login' => $username,
			'role'       => get_option( 'user_registration_social_setting_default_user_role', 'subscriber' )
		);

		if ( 'no' === get_option( 'user_registration_social_setting_enable_social_registration', 'no' ) ) {

			return __( 'Could not register user, please contact with site administrator', 'user-registration-social-connect' );
		}
		$user_id = self::register_user( $user_data );

		if ( is_wp_error( $user_id ) ) {

			return $user_id->get_error_message();

		}

		self::update_network_connection( $user_id, array(

			'network'  => $network,
			'username' => $username,
			'profile'  => $profile
		) );

		return $user_id;

	}


}

return new URSC_Social_Data();
