<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$social_networks = user_registration_social_networks();

$redirect_to = isset( $_REQUEST['redirect_to'] ) ? $_REQUEST['redirect_to'] : '';

$encoded_url = '';
?>
<div class="user-registration-social-connect-networks">

	<?php

	if ( count( $social_networks ) > 0 ) {
		?>
		<ul class="ursc-network-lists <?php echo get_option( 'user_registration_social_login_template', 'ursc_theme_4' ) ?>">
			<?php
			foreach ( $social_networks as $network_key => $network_data ) {
				if ( 'yes' === get_option( $network_data['enable_id'] ) ) { ?>
					<li class="ursc-login-media ursc-login-media--<?php echo $network_key ?>">
						<a href="<?php echo wp_login_url(); ?>?user_registration_social_login=<?php echo $network_key; ?>&ursc_action=login<?php
						if ( $encoded_url ) {
							echo "&state=" . base64_encode( "redirect_to=$encoded_url" );
						}
						?>" title='<?php
						_e( 'Login with', 'user-registration-social-connect' );
						echo ' ' . $network_key;
						?>'>
							<span class="ursc-icon-block icon-<?php echo $network_key; ?> ursc-login-with-<?php echo $network_key; ?>"></span>

							<?php if ( 'ursc_theme_4' === get_option( 'user_registration_social_login_template' ) ) { ?>
								<span class="ursc-login-text"><?php echo esc_html( get_option( $network_data['login_text'] ) ); ?></span>
							<?php } ?>
						</a>
					</li>
					<?php

				}
			}
			?>
		</ul>

		<?php
	}
	?>
</div>


