<?php
/**
 * URWC_Ajax
 *
 * AJAX Event Handler
 *
 * @class    URWC_Ajax
 * @version  1.0.0
 * @package  UserRegistrationFileUpload/Classes
 * @category Class
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URWC_Ajax Class
 */
class URWC_Ajax {

	/**
	 * Hooks in ajax handlers
	 */

	public static function init() {
		self::add_ajax_events();
	}

	/**
	 * Hook in methods - uses WordPress ajax handlers (admin-ajax)
	 */
	public static function add_ajax_events() {

		$ajax_events = array(
			'test' => true,
		);

		foreach ( $ajax_events as $ajax_event => $nopriv ) {
			add_action( 'wp_ajax_user_registration_woocommerce_' . $ajax_event, array( __CLASS__, $ajax_event ) );
			if ( $nopriv ) {
				add_action( 'wp_ajax_nopriv_user_registration_woocommerce_' . $ajax_event, array(
					__CLASS__,
					$ajax_event
				) );
			}
		}
	}
}

URWC_Ajax::init();
