<?php

/**
 * Class WP_Scratch_MyCred
 */
class WP_Scratch_MyCred extends myCRED_Hook {

	/**
	 * @var User_ScratchIt_Data
	 */
	private $db_user_data;

    /**
     * @param array $hooks_prefs
     */
    public function __construct($hooks_prefs, $type)
	{
			parent::__construct(array(
					'id' => 'wp_scratchit',
					'defaults' => array(
						'default_points' => 1,
						'log' => 'Compeleted Scratching' 
					)
				), $hooks_prefs, $type);

			$this->db_user_data = new User_ScratchIt_Data();
	}

    /**
     * @return bool|void
     */
	public static function setup_hook()
	{
		add_filter( 'mycred_setup_hooks', function($installed)
		{
			$installed['wpscratchit'] = array(
				'title'       => __( 'WP ScratchIt'),
				'description' => __( "Let's users win points by scratching Scratch Cards"),
				'callback'    => array( 'WP_Scratch_MyCred' )
			);

			return $installed;
		});
	}

    /**
     *
     */
    public function run()
	{
		add_action('wp_ajax_scratchit_scratched', [$this, 'process_ajax']);
        add_action('wp_ajax_nopriv_scratchit_scratched', [$this, 'process_ajax_anonymous']);
	}

    /**
     *
     */
    public function preferences()
	{
			$prefs = $this->prefs;
			?>

			<label class="subheader"><?php _e('Default Points') ?></label>
			<ol>
				<li>
					<div class="h2"><input type="text" name="<?php echo $this->field_name( 'default_points' ); ?>" id="<?php echo $this->field_id( 'default_points' ); ?>" value="<?php echo $this->core->format_number( $prefs['default_points'] ); ?>" size="8" /></div>
				</li>
			</ol>
			<?php
	}

    /**
     * @param $data
     * @return mixed
     */
    public function sanitize_preferences( $data )
	{
		$new_data = $data;
		$new_data['max_points'] =  empty($new_data['max_points']) ? 5 : filter_var($new_data['max_points'], FILTER_VALIDATE_INT);
		return $new_data;
	}

    /**
     * Process ajax
     */
    public function process_ajax()
	{

        $post_id = $_POST['id']  - 49686;

        if ($post_id < 0) return;  // just to hide the id the value can't be negative

		if (!is_user_logged_in()) return;
		
		$user_id = get_current_user_id();

		if ( $this->core->exclude_user( $user_id ) ) return;

		$options = get_option('wp_scratchit_options');

		if ($options['wp_scratchit_only_once'] == TRUE ) {
			if ($this->core->has_entry('completing_scratching', $post_id, $user_id)) return;
		}

		$card = new WP_ScratchIt_CardsGetter($post_id, $options = get_option('wp_scratchit_options'));
		$card = $card->get(TRUE);
		$score = ($card->getMycredPoints() != null) ? $card->getMycredPoints() : $this->prefs['default_points'];

		$_SESSION['preUserResult'] = null;

		$this->core->add_creds(
				'completing_scratching',
				$user_id,
				$score,
				$this->prefs['log'],
				$post_id,
				array('ref_type' => 'post'),
				$this->mycred_type
			);
			
	}

	public function process_ajax_anonymous()
    {
        $post_id = $_POST['id']  - 49686;
        if ($post_id < 0) return;  // just to hide the id the value can't be negative
        $card = new WP_ScratchIt_CardsGetter($post_id, $options = get_option('wp_scratchit_options'));
        $card->get(TRUE);
    }
}
?>