<?php 

/**
 * WordPress ScratchIt
 * @url http://devplus31.com/wpscratchit
 * @version 1.5.0
 * @author DevPlus31
 */

class WP_ScratchIt_Options {

    /**
     * @var mixed|void
     */
    public $options;

    /**
     *
     */
    public function __construct()
	{
		$this->options = get_option('wp_scratchit_options');
		$this->register_fields();


	}

    /**
     *
     */
    public static function setup_page_options()
	{
		add_options_page('WP ScratchIt', 'WP ScratchIt', 'administrator', __FILE__, ['WP_ScratchIt_Options', 'setup_menu_option']);

	}

    /**
     *
     */
    public static function setup_menu_option()
	{
		?>
		<div class="wrap">
				<h2><?php __('WP ScratchIt Settings') ?></h2>
				<form method="post" action="options.php" enctype="multipart/form-data">						
					<?php settings_fields('wp_scratchit_options'); ?>
					<?php do_settings_sections(__FILE__); ?>

					<p class="submit">
						<input name="submit" type="submit" class="button-primary" value="Save Changes" />			
					</p>
 				</form>
			</div>
		<?php
	}

    /**
     *
     */
    public function register_fields()
	{
		register_setting('wp_scratchit_options', 'wp_scratchit_options', [$this, 'wp_scratchit_validate_settings']);
		add_settings_section('wp_scratchit_main_section', __('Main Settings'), [$this, 'wp_scratchit_main_section_cb'], __FILE__);
		add_settings_field('wp_scratchit_foreground', __('Default Scratch foreground: '), [$this, 'wp_scratchit_background_setting'], __FILE__, 'wp_scratchit_main_section');
//		add_settings_field('wp_scratchit_color', __('Scratch Color: '), [$this, 'wp_scratchit_color_setting'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_icon', __('Scratch Icon: '), [$this, 'wp_scratchit_icon_setting'], __FILE__, 'wp_scratchit_main_section'); 
		add_settings_field('wp_scratchit_radius', __('Radius'), [$this, 'wp_scracthit_radius_setting'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_scratchafter', __('Automatically scratch After'), [$this, 'wp_scratchit_scratchafter'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_clean', __('Remove Generated Images'), [$this, 'wp_scratchit_clean'], __FILE__, 'wp_scratchit_main_section');
//add_settings_field('wp_scratchit_use_mycred', __('Use MyCred'), [$this, 'wp_scratchit_use_mycred'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_save_values', __('Save Generated Values'), [$this, 'wp_scratchit_save_values'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_only_once', __('User scratch only once'), [$this, 'wp_scratchit_once_value'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_reset_values', __('Reset Scratch Card History'), [$this, 'wp_scratchit_reset_history'], __FILE__, 'wp_scratchit_main_section');
		add_settings_field('wp_scratchit_allow_anonymous', __('Allow Anonymous'), [$this, 'wp_scratchit_allow_anonymous'], __FILE__, 'wp_scratchit_main_section');

	}

    /**
     * @param $plugin_options
     * @return mixed
     */
    public function wp_scratchit_validate_settings($plugin_options)
	{
		$keys = array(
			'wp_scratchit_foreground_upload',
		//	'wp_scratchit_use_mycred',
			'wp_scratchit_icon_upload',
			'wp_scratchit_color',
			'wp_scratchit_radius_size',
			'wp_scratchit_scratchafter',
			'wp_scratchit_save_values',
			'wp_scratchit_only_once',
			'wp_scratchit_clean',
			'wp_scratchit_allow_anonymous'
		);


		foreach ($keys as $key) {
			if (isset($_POST[$key])) {
				if ($key == 'wp_scratchit_foreground_upload' || $key == 'wp_scratchit_icon_upload')
				{
					$file = $_POST[$key];
					$key = str_replace('_upload', '' , $key );
					if (empty($file)) { continue; } // Must use Default Urls.
					$plugin_options[$key] = $file;
				}
				else if ($key == 'wp_scratchit_color')
				{
					if (preg_match('/^#[a-f0-9]{6}$/i', $_POST['wp_scratchit_color']))
					{
						$plugin_options[$key] = sanitize_text_field($_POST[$key]);
					}
					else
					{
						add_settings_error($key, '', __('Incorrect color code'), 'error');
						$plugin_options[$key] = $this->options[$key];
					}

				}
				else if ($key == 'wp_scratchit_radius_size' || $key == 'wp_scratchit_scratchafter')
				{
					if ((int)$_POST[$key])
					{
						$plugin_options[$key] = (int)$_POST[$key];
					}
					else
					{
						add_settings_error($key, '', __('Incorrect Value'), 'error');
						$plugin_options[$key] = $this->options[$key];
					}

				}
				else
				{

					$plugin_options[$key] = true;
				}
			}
			else
			{
				$plugin_options[$key] =  null; // $this->options[$key];
			}
		}

		return $plugin_options;
	}


    /**
     *
     */
    public function wp_scratchit_color_setting()
	{
		?>	
			<input type='text' name='wp_scratchit_color' class="meta-color" value='<?= $this->options["wp_scratchit_color"]?>'/>
		<?php
	}

    /**
     *
     */
    public function wp_scratchit_background_setting()
	{
		?>

		<input type='text' id="background_img" class='upload_image' name='wp_scratchit_foreground_upload' value='<?= isset($this->options['wp_scratchit_foreground']) ? $this->options["wp_scratchit_foreground"] : '' ?>'/>
		<input type="button" class="button upload_image_btn" value="<?php _e( 'Choose or Upload an Image', 'prfx-textdomain' )?>" /><br/><br/>
		
		<?php if (isset($this->options['wp_scratchit_foreground'])): ?>
			<img src='<?= $this->options['wp_scratchit_foreground'] ?>' alt='' />
		<?php endif ?>
		
		<?php
	}

    /**
     *
     */
    public function wp_scratchit_icon_setting()
	{
		?>
		<input type='text' id="icon_img" name='wp_scratchit_icon_upload' value='<?= isset($this->options['wp_scratchit_icon']) ? $this->options["wp_scratchit_icon"] : '' ?>'/>
		<input type="button" class="button upload_image_btn" value="<?php _e( 'Choose or Upload an Image', 'prfx-textdomain' )?>" /><br/><br/>
		
		<?php if (isset($this->options['wp_scratchit_icon'])): ?>
			<img height="30" width="30" src="<?= $this->options["wp_scratchit_icon" ] ?>" alt="" />
		<?php endif ?>
		<?php
	}

    /**
     *
     */
    public function wp_scracthit_radius_setting()
	{
		?>
		<input type="number" name="wp_scratchit_radius_size" value="<?= $this->options["wp_scratchit_radius_size"] ?>"/><br/></br>
		<?php
	}

    /**
     *
     */
    public function wp_scratchit_scratchafter()
	{
		?>
		<input name="wp_scratchit_scratchafter" type="number" value="<?= $this->options["wp_scratchit_scratchafter"] ?>" />
		<p class="description">
			Number must be lower than 100
		</p>
		<?php
	}

	public function wp_scratchit_use_mycred()
	{
		?>
		<input type="checkbox" name="wp_scratchit_use_mycred" <?= ($this->options["wp_scratchit_use_mycred"]) ? 'checked' : ''; ?>  value="<?= $this->options["wp_scratchit_use_mycred"] ?>"/>
		<p class="description">
			MyCred Plugin must be installed
		</p>
		<br/>
		<?php
	}

	public function wp_scratchit_save_values()
	{
		?>
		<input type="checkbox" name="wp_scratchit_save_values" <?= ($this->options["wp_scratchit_save_values"]) ? 'checked' : ''; ?> value="<?= $this->options["wp_scratchit_save_values"] ?>"/>
		<p class="description">
			This option save all card result (for logged in user only)
		</p>
		<br/>
		<?php
	}

	public function wp_scratchit_once_value()
	{
		?>
		<input type="checkbox" name="wp_scratchit_only_once" <?= ($this->options["wp_scratchit_only_once"]) ? 'checked' : ''; ?> value="<?= $this->options["wp_scratchit_only_once"] ?>"/>
		<p class="description">
			This option prevent users to update their card by refreshing the page.
			<br>
			Note: Save Generated values must be enabled.
		</p>
		<br/>
		<?php
	}

	public function wp_scratchit_clean()
	{
		?>
		<input type="checkbox" name="wp_scratchit_clean" <?= ($this->options["wp_scratchit_clean"]) ? 'checked' : ''; ?> value="<?= $this->options["wp_scratchit_clean"] ?>"/>
		<p class="description">
			Automatically remove generated images when ScratchIt post is deleted.
		</p>
		<br/>
		<?php
	}

	public function wp_scratchit_allow_anonymous()
	{
		if (!isset($this->options['wp_scratchit_allow_anonymous']))
			$this->options['wp_scratchit_allow_anonymous'] = '';
		?>

		<input type="checkbox" name="wp_scratchit_allow_anonymous" <?= ($this->options["wp_scratchit_allow_anonymous"]) ? 'checked' : ''; ?> value="<?= $this->options["wp_scratchit_allow_anonymous"] ?>"/>
		<p class="description">
			Allow anonymous users to scratch cards.
		</p>
		<br/>
		<?php
	}

	public function wp_scratchit_reset_history()
	{
        ?>
        <button name="wp_scratchit_reset_history" class="reset_history">Reset</button>
        <p class="description">
            Reset history of Scratching, Users will be able to scratch the cards again. their last result will be deleted. 
        </p>
        <?php
	}

	public static function remove_scratch_entry()
    {
        global $wpdb;
        WPScratchIt_Posts::resetAllPostsWinnersMeta();
        $results = $wpdb->get_results("TRUNCATE TABLE $wpdb->prefix"."wp_scratchit");
        return $results;
    }

    /**
     *
     */
    public function wp_scratchit_main_section_cb()
	{
		
	}
}