<?php
/**
 * Created by PhpStorm.
 * User: DevPlus31
 * Date: 18/12/2015
 * Time: 00:10
 */

/**
 * Class User_ScratchIt_Data
 */
class User_ScratchIt_Data
{
    /**
     * @var wpdb
     */
    private $db;

    /**
     * @var string
     */
    private $table = 'wp_scratchit';

    /**
     * User_ScratchIt_Data constructor.
     */
    public function __construct()
    {
        global $wpdb;
        $this->db = $wpdb;
    }

    /**
     * @param $user_id User ID
     * @param $post_id Scratch Card post ID
     * @param $result Generated value
     * @param $ip_address
     */
    public function saveUserResult($user_id, $post_id, $result, $ip_address)
    {
        $table = $this->db->prefix. $this->table;
        $this->db->insert($table,
            array(
                'user_id' => $user_id,
                'value' => $result,
                'value_id' => $post_id,
                'at_time' => date('Y-m-d H:i:s'),
                'ipAddress' => $ip_address,
             //   'istemp'  => false
        ));
    }


    /**
     * @param $user_id
     * @param $post_id
     * @param $result
     * Future Usage
     * @param $ip_address
     */
    public function preSaveResult($user_id, $post_id, $result, $ip_address)
    {
        if ($user_id == -1)
            $user_id = $_SERVER['REMOTE_ADDR'];

        $table = $this->db->prefix. $this->table;
        $this->db->insert($table,
            array(
                'user_id' => $user_id,
                'value' => $result,
                'value_id' => $post_id,
                'at_time' => date('Y-m-d H:i:s'),
                'ipAddress' => $ip_address,
                'istemp' => true
            ));
    }


    /**
     * @param $user_id
     * @param $post_id
     * @return bool
     */
    public function hasPreSavedResult($user_id, $post_id)
    {
        if (count($this->getPreSavedResult($user_id, $post_id)))
        {
            return TRUE;
        }

        return FALSE;
    }

    /**
     * @param $user_id
     * @param $post_id
     * @return array|null|object
     * Future Usage
     */
    public function getPreSavedResult($user_id, $post_id)
    {
        $table = $this->db->prefix. $this->table;
        return $this->db->get_results("SELECT id,value FROM $table 
               WHERE user_id = '$user_id' AND value_id = '$post_id' AND istemp = 1");
    }

    /**
     * @param $user_id
     * @param $post_id
     * @param bool $old_value
     * @return array|null|object
     */
    public function getUserResult($user_id, $post_id, $old_value = false)
    {
        $table = $this->db->prefix. $this->table;
        return $this->db->get_results("SELECT id,value FROM $table 
               WHERE user_id = '$user_id' AND value_id = '$post_id'");
    }

    /**
     * @param $user_id
     * @param $post_id
     * Future Usage
     */
    public function approveResult($user_id, $post_id)
    {
        $table = $this->db->prefix. $this->table;
        $result = $this->db->get_results("SELECT id FROM $table 
               WHERE user_id = '$user_id' AND value_id = '$post_id' AND istemp = 1");


    }

    /**
     * @param $user_id
     * @param $post_id
     * @return bool
     */
    public function hasUserScratch($user_id, $post_id)
    {
        if (count($this->getUserResult($user_id, $post_id)))
        {
            return TRUE;
        }

        return FALSE;
    }

    /**
     * @param $user_id
     * @param $post_id
     * @return false|int
     */
    public function removeUserScratch($user_id, $post_id)
    {
        return $this->db->delete($this->db->prefix.$this->table,
            array(
                'user_id' => $user_id,
                'value_id' => $post_id
            ));
    }

    /**
     * @param $id
     * @return false|int
     */
    public function removeUserScratchByID($id)
    {
        return $this->db->delete($this->db->prefix.$this->table,
            array(
                'id' => $id
            ));
    }

    /**
     * @return int
     */
    public function countNumberOfEntries()
    {
        $table = $this->db->prefix. $this->table;
        $result = $this->db->get_results("SELECT id,value FROM $table");
        return count($result);
    }

    /**
     * @param $post_id
     * @return int
     */
    public function countNumberEntriesByCard($post_id)
    {
        $table = $this->db->prefix. $this->table;
        $result = $this->db->get_results("SELECT id,value FROM $table 
            WHERE value_id = '$post_id'");
        return count($result);
    }

    /**
     * @param $user_id
     * @return array|null|object
     */
    public function getEntriesByUserId($user_id)
    {
        $table = $this->db->prefix. $this->table;
        return $this->db->get_results("SELECT id,value FROM $table 
               WHERE user_id = '$user_id'");

    }


}