<?php
/**
 * Add extra profile fields for users in WordPress Profile Page
 *
 * @author   WPEverest
 * @category Admin
 * @package  UserRegistration/Admin
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'URAF_Admin_Profile', false ) ) :

	/**
	 * UR_Admin_Profile Class.
	 */
	class URAF_Admin_Profile {

		/**
		 * Constructor
		 */
		public function __construct() {
			add_filter( 'user_registration_profile_field_filter_html', array( $this, 'profile_fields_data' ), 10, 1 );
			add_filter( 'user_registration_profile_field_filter_wysiwyg', array( $this, 'profile_fields_data' ), 10, 1 );
			add_filter( 'user_registration_profile_field_filter_section_title', array( $this, 'profile_fields_data' ), 10, 1 );

			add_action(	'user_registration_profile_field_html', array( $this, 'render_advanced_fields' ), 10, 1 );
			add_action(	'user_registration_profile_field_wysiwyg', array( $this, 'render_advanced_fields' ), 10, 1 );
		}

		/**
		 * Hook field type for access in profile page
		 * @param  mixed $filter_data
		 * @return mixed
		 */
		public function profile_fields_data( $filter_data) {
			$field		=  $filter_data['field'];
			$field_name 	= isset( $field->general_setting->field_name ) ? $field->general_setting->field_name : '';
			$field_index 	= 'user_registration_' . $field_name;
			$field_key 		= isset( $field->field_key ) ? $field->field_key : '';
			switch ( $field_key ) {
				case 'html':
					$field_index 	= 'user_registration_'.$field_name;
					$field_key 		= isset( $field->field_key ) ? $field->field_key : '';
					$filter_data[ 'fields' ][ $field_index ]['type']  = 'html';
					$filter_data[ 'fields' ][ $field_index ]['html']  = isset( $field->general_setting->html ) ? $field->general_setting->html : '';
					break;
				case 'wysiwyg':
					$filter_data[ 'fields' ][ $field_index ]['type']  = 'wysiwyg';
					break;
				case 'section_title':
					$field_index 	= 'user_registration_'.$field_name;
					$field_key 		= isset( $field->field_key ) ? $field->field_key : '';
					$filter_data[ 'fields' ][ $field_index ]['type']  = 'section_title';
					break;
			}
			return $filter_data;

		}

		/**
		 * render advanced fields in WP Profile page
		 * @param  array $data
		 */
		public function render_advanced_fields( $data ) {
			extract( $data );
			switch ( $data[ 'field' ][ 'type' ] ) {
				case 'html':
					echo $field['html'];
					break;
				case 'wysiwyg':
					$pos = strpos( $key, 'user_registration_' );
					if ( $pos !== false ) {
    					$id = substr_replace( $key, '', $pos, strlen('user_registration_') );
					}

					$settings = array(
						'media_buttons' => false,
						'textarea_name' => $key
					);
					wp_editor( $value, $id, $settings );

					break;
			}
		}
	}

endif;

return new URAF_Admin_Profile();
