<?php
/**
 * UserRegistrationAdvancedFields Admin.
 *
 * @class    URAF_Admin
 * @version  1.0.0
 * @package  UserRegistrationAdvancedFields/Admin
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URAF_Admin Class
 */
class URAF_Admin {

	public $advanced_fields = [];

	/**
	 * Constructor.
	 */
	public function __construct() {
		uraf_check_plugin_compatibility();
		$message = uraf_is_compatible();

		if ( $message !== 'YES' ) {
			return;
		}

		$this->advanced_fields = user_registration_list_advanced_fields();
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		add_action(	'user_registration_extra_fields', array( $this, 'user_registration_render_advanced_fields' ) );
		foreach( $this->advanced_fields as $field ) {
			add_filter( 'user_registration_'. $field. '_admin_template', array( $this, 'user_registration_af_fields_admin_template_includes' ), 10, 1 );
		}
		add_filter( 'user_registration_field_options_general_settings', array( $this, 'field_settings' ), 10, 2 );
	}

	/**
	 * Enequeue Admin Scripts
	 * @since  1.0.1
	 * @return void
	 */
	public function admin_scripts() {
		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		wp_register_script( 'user-registration-advanced-fields-admin', URAF()->plugin_url() . '/assets/js/admin/user-registration-advanced-fields-admin' . $suffix . '.js', array(
				'jquery',
			), URAF_VERSION );

		wp_enqueue_script( 'user-registration-advanced-fields-admin' );
	}

	/**
	 * Display advanced Field Section
	 * @since 1.0
	 */
	public function user_registration_render_advanced_fields() {

		echo '<h2>' . __( 'Advanced Fields', 'user-registration-advanced-fields' ) . '<span class="ur-advanced-toggle dashicons dashicons-arrow-up-alt2"></span></h2><hr/>';

		$this->get_advanced_fields();
	}

	/**
	 * Render all the advanced fields
	 * @since  1.0
	 */
	public function get_advanced_fields() {

		$registered_form_fields =  $this->advanced_fields;

		echo ' <ul id = "ur-draggabled" class="ur-registered-list ur-advanced-fields" > ';

		$get_list = new UR_Admin_Menus;

		foreach ( $registered_form_fields as $field ) {

				$get_list->ur_get_list( $field );
			}
			echo ' </ul > ';
	}

	/**
	 * @param $path
	 *
	 * @return string
	 */
	public function user_registration_af_fields_admin_template_includes( $path ) {

		$core_path = UR_ABSPATH;
		$addon_path = URAF_ABSPATH;
		$path =	str_replace( $core_path, $addon_path, $path );

		return $path;
	}

	/**
	 * @param $path
	 *
	 * @return array
	 * @param array $general_settings general field settings
	 */
	public function field_settings( $general_settings, $id ) {

		switch ( $id ) {
			case 'user_registration_section_title':
				$remove_keys = array( 'placeholder', 'required', 'hide_label' );
				foreach( $remove_keys as $remove_key ) {
					unset( $general_settings[ $remove_key ] );
				}
			break;

			case 'user_registration_timepicker':
			case 'user_registration_wysiwyg':
			case 'user_registration_phone':
				unset( $general_settings[ 'placeholder'] );
				$input_mask = array(
					'input_mask'      => array(
						'type'        => 'text',
						'label'       => __( 'Input Mask', 'user-registration-advanced-fields' ),
						'name'        => 'ur_general_setting[input_mask]',
						'placeholder' => '',
						'required'    => true,
					)
				);
				$general_settings = array_merge( $general_settings, $input_mask );

			break;

			case 'user_registration_html':
				$remove_keys = array( 'placeholder', 'required', 'hide_label' );
				foreach( $remove_keys as $remove_key ) {
					unset( $general_settings[ $remove_key ] );
				}
				$new_settings = array(
					'html'      => array(
						'type'        => 'textarea',
						'label'       => __( 'HTML', 'user-registration-advanced-fields' ),
						'name'        => 'ur_general_setting[html]',
						'placeholder' => __( 'Custom HTML', 'user-registration-advanced-fields' ),
						'required'    => true,
					)
				);
				$general_settings = array_merge( $general_settings, $new_settings );
				break;
		}

		return $general_settings;
	}
}

return new URAF_Admin();