/* global  ursc_script_data */
(function ($) {
  $(document).ready(function () {
    setTimeout(function () {
      $('.ursc_network_thickbox').click();
    }, 1000);
    $('body').on('click', '.ursc_next_social_button', function () {
    	var $this_node = $(this);
      var email_field = $('input[name="ursc_dialog_email"]');
      var password = $('input[name="ursc_dialog_password"]');
      if (password.length > 0 && '' === password.val()) {
        window.alert('Empty password');
        return;
      }
      if ('' !== email_field.val() && ursc_validate_email(email_field.val())) {
        var nonce = $(this).closest('p').find('input[name="security"]').val();
        var network = $(this).closest('p').find('input[name="network"]').val();
        var username = $(this).closest('p').find('input[name="username"]').val();
        var profile = $(this).closest('p').find('input[name="profile"]').val();
	      $this_node.prepend('<span class="ursc-front-spinner"/>');
        var data = {
          security: nonce,
          email: email_field.val(),
          action: 'user_registration_social_connect_network_access_post',
          username: username,
          profile: profile,
          network: network,
          password: password.val()
        };
        $.ajax({
          url: ursc_script_data.ajax_url,
          data: data,
          type: 'POST',
          beforeSend: function () {
          },
          complete: function (ajax_response) {
          	$this_node.find('span').remove();
            var error_message = '';
            try {
              var response_obj = $.parseJSON(ajax_response.responseText);
              if ('undefined' !== typeof response_obj.success && true === response_obj.success) {
                window.location = response_obj.data.redirect_url;
                return;
              }
              if ('undefined' !== typeof response_obj.success && false === response_obj.success) {
                if ('undefined' !== response_obj.data.error) {
                  error_message = response_obj.data.error;
                } else {
                  error_message = 'Something wrong, please try again.';
                }
              } else {
                error_message = 'Something wrong, please try again.';
              }
            } catch (e) {
              error_message = e.message;
            }
            if ('' !== error_message) {
              $('.tb-close-icon').trigger('click');
              var error_node = '<div id="login_error">\t<strong>ERROR</strong>: ' + error_message + '<br></div>';
              $('#login_error').remove();
              $('#login').find('h1').after(error_node);
            }
          }
        });
      } else {
        window.alert('Email not valid.');
      }
    });
    function ursc_validate_email($email) {
      var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
      return regex.test($email);
    }
    if ($('body').find('.user-registration-social-connect-networks-error').length > 0) {
      var error = $('body').find('.user-registration-social-connect-networks-error').text();
      var login_error = '<div id="login_error"><strong>ERROR</strong>: ' + error + '<br></div>';
      $('body').find('#login').find('#login_error').remove();
      $('body').find('#login').find('h1').after(login_error);
    }
  });
}(jQuery));
