<?php
/**
 * UserRegistration URSC_AJAX
 *
 * AJAX Event Handler
 *
 * @class    URSC_AJAX
 * @version  1.0.0
 * @package  UserRegistrationSocialConnect/Classes
 * @category Class
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URSC_AJAX Class
 */
class URSC_AJAX {

	/**
	 * Hooks in ajax handlers
	 */

	public static function init() {

		self::add_ajax_events();

	}

	/**
	 * Hook in methods - uses WordPress ajax handlers (admin-ajax)
	 */
	public static function add_ajax_events() {

		$ajax_events = array(
			'network_access_post' => true,
		);

		foreach ( $ajax_events as $ajax_event => $nopriv ) {

			add_action( 'wp_ajax_user_registration_social_connect_' . $ajax_event, array( __CLASS__, $ajax_event ) );

			if ( $nopriv ) {
				add_action( 'wp_ajax_nopriv_user_registration_social_connect_' . $ajax_event, array(
					__CLASS__,
					$ajax_event
				) );
			}
		}
	}

	/**
	 * user input dropped function
	 */
	public static function network_access_post() {
		try {

			check_ajax_referer( 'ursc_social_submit', 'security' );

			$email = isset( $_POST['email'] ) ? sanitize_text_field( $_POST['email'] ) : '';

			$network = isset( $_POST['network'] ) ? sanitize_text_field( $_POST['network'] ) : '';

			$username = isset( $_POST['username'] ) ? sanitize_text_field( $_POST['username'] ) : '';

			$profile = isset( $_POST['profile'] ) ? sanitize_text_field( $_POST['profile'] ) : '';

			$password = isset( $_POST['password'] ) ? ( $_POST['password'] ) : '';

			$social_networks = user_registration_social_networks();

			if ( ! isset( $social_networks [ $network ] ) || empty( $email ) || empty( $network ) || empty( $username ) || empty( $profile ) ) {

				throw  new Exception( 'Something error occur. Please try again.' );
			}

			$ursc_network_data = user_registration_social_connect_get_session( 'ursc_social_network_data' );

			if ( ! ursc_check_network_session_exists( $ursc_network_data ) ) {

				throw new Exception( 'Sorry someting wrong' );
			}

			$post_data  = array(
				'email'    => $email,
				'username' => $username,
				'profile'  => $profile,
				'network'  => $network,
			);
			$is_matched = ursc_has_matched_with_session( $ursc_network_data, $post_data );

			if ( ! $is_matched ) {

				throw new Exception( 'Sorry ! Requested data not matched.' );
			}

			$response_params      = array(

				'redirect_url' => ursc_social_login_redirect()
			);
			$is_already_connected = URSC_Social_Data::is_already_connected_network( $username, $network, $email );
			if ( $is_already_connected ) {
				$user   = get_user_by( 'email', $email );
				$status = URSC_Social_Data::login_user( $user->ID );
				if ( is_wp_error( $status ) ) {
					throw  new Exception( $status->get_error_message() );
				}
				wp_send_json_success( $response_params );

			} else if ( URSC_Social_Data::is_already_connected_network( $username, $network ) && ! $is_already_connected ) {
				ursc_flush_all();
				wp_send_json_error( array(
					'error' => 'already associated this account.',
				) );

			} else if ( email_exists( $email ) ) {

				$user = get_user_by( 'email', $email );

				if ( $user && wp_check_password( ( $password ), $user->data->user_pass, $user->ID ) ) {

					URSC_Social_Data::update_network_connection( $user->ID, $post_data );

					$status = URSC_Social_Data::login_user( $user->ID );

					if ( is_wp_error( $status ) ) {
						throw  new Exception( $status->get_error_message() );
					}
					//ursc_flush_all();
					wp_send_json_success( $response_params );

				} else {
					wp_send_json_error( array(
						'error' => 'Password not matched, please try again.',
					) );

				}

			}

			// Create user with random password and login and send json with redirect url.

			if ( empty( $password ) ) {

				throw new Exception( __( 'Empty password', 'user-registration-social-connect' ) );
			}
			$user_id = URSC_Social_Data::ursc_register_user( $email, $username, $network, $profile, $password );
			if ( ! is_numeric( $user_id ) ) {

				ursc_flush_all();

				wp_send_json_error( array(
					'error' => $user_id,
				) );


			}
			$status = URSC_Social_Data::login_user( $user_id );
			if ( is_wp_error( $status ) ) {
				throw  new Exception( $status->get_error_message() );
			}
			wp_send_json_success( $response_params );

		}
		catch ( Exception $e ) {
			ursc_flush_all();
			wp_send_json_error( array(
				'error' => $e->getMessage(),
			) );

		}
	}


}

URSC_AJAX::init();
