<?php
/**
 * UserRegistrationSocialConnect Frontend.
 *
 * @class    URSC_Frontend
 * @version  1.0.0
 * @package  UserRegistrationSocialConnect/Admin
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URSC_Frontend Class
 */
class URSC_Frontend {

	/**
	 * Hook in tabs.
	 */
	private $wp_error;

	public function __construct() {

		global $ursc_response_global;
		add_action( 'login_form', array( $this, 'add_ur_social_login' ) );
		add_action( 'init', array( $this, 'social_login_check' ) ); //check for the social logins
		add_action( 'user_registration_login_form_end', array(
			$this,
			'add_ur_social_login'
		) ); //check for the social logins
		add_action( 'user_registration_login_form_end', array( $this, 'user_registration_social_scripts' ) );
		add_action( 'login_enqueue_scripts', array( $this, 'user_registration_social_scripts' ) );
		add_filter( 'login_message', array( $this, 'login_message' ) );


	}

	/**
	 * @param $message
	 */
	public function login_message() {

		if ( is_wp_error( $this->wp_error ) ) {
			echo '<div id="login_error">' . $this->wp_error->get_error_message() . '</div>';
		}

	}

	public function user_registration_social_scripts() {

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
		wp_register_script( 'user-registration-social-connect-script', URSC()->plugin_url() . '/assets/js/frontend/user-registration-social-connect-script' . $suffix . '.js', array( 'jquery' ), URSC_VERSION );
		wp_register_style( 'user-registration-social-connect-style', URSC()->plugin_url() . '/assets/css/user-registration-social-connect-style.css', array(), URSC_VERSION );

		wp_enqueue_script( 'user-registration-social-connect-script' );

		wp_localize_script( 'user-registration-social-connect-script', 'ursc_script_data', array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
		) );
		wp_enqueue_style( 'user-registration-social-connect-style' );

	}

	public function add_ur_social_login() {

		if ( ! is_user_logged_in() ) {

			$this->check_email_response();

			include( 'views/social-login-template.php' );

		}

	}

	public function check_email_response() {

		global $ursc_response_global;

		if ( is_wp_error( $this->wp_error ) ) {

			return;
		}

		if ( isset( $ursc_response_global['status'] ) && 'SUCCESS' === $ursc_response_global['status'] ) {

			if ( isset( $ursc_response_global['data'] ) && isset( $ursc_response_global['data']['email'] ) ) {

				$network_data = array(
					'email'     => $ursc_response_global['data']['email'],
					'username'  => $ursc_response_global['data']['username'],
					'profile'   => $ursc_response_global['data']['profile'],
					'network'   => isset( $ursc_response_global['network'] ) ? $ursc_response_global['network'] : '',
					'has_email' => ! empty( $ursc_response_global['data']['email'] ) ? true : false,

				);

				user_registration_social_connect_set_session( 'ursc_social_network_data', $network_data );

				$error_message = '';
				// Check if network account is already associated wtith email address
				$is_already_connected = URSC_Social_Data::is_already_connected_network( $network_data['username'], $network_data['network'], $network_data['email'] );

				if ( $is_already_connected ) {

					//URSC_Social_Data::check_user_and_login( $network_data );

				} else if ( URSC_Social_Data::is_already_connected_network( $network_data['username'], $network_data['network'] ) && ! $is_already_connected ) {

					$error_message = "already associated this account.";

					include( 'views/social-login-dialog-template.php' );

				} else {

					include( 'views/social-login-dialog-template.php' );
				}

				return;
			}
		}

		include( 'views/social-login-error-template.php' );


	}

	public function social_login_check() {
		if ( isset( $_GET['user_registration_social_login'] ) ) {
			if ( isset( $_REQUEST['state'] ) ) {
				parse_str( base64_decode( $_REQUEST['state'] ), $state_vars );

				if ( isset( $state_vars['redirect_to'] ) ) {
					$_GET['redirect_to'] = $_REQUEST['redirect_to'] = $state_vars['redirect_to'];
				}
			}

			$social_network      = $_GET['user_registration_social_login'];
			$all_social_networks = user_registration_social_networks();

			if ( isset( $all_social_networks[ $social_network ] ) ) {
				$api_key    = get_option( $all_social_networks[ $social_network ]['key_id'] );
				$api_secret = get_option( $all_social_networks[ $social_network ]['secret_id'] );
				switch ( $social_network ) {
					case 'twitter':
						$twitter_network = new URSC_Network_Twitter();
						$twitter_network->request( $api_key, $api_secret );
						break;
					case 'google':
						$google_network = new URSC_Network_Google();
						$google_network->request( $api_key, $api_secret );
						break;
					case 'facebook':
						$facebook_network = new URSC_Network_Facebook();
						$facebook_network->request( $api_key, $api_secret );
						break;
					case 'linkedin':
						$linkedin_network = new URSC_Network_Linkedin();
						$linkedin_network->request( $api_key, $api_secret );
						break;

				}
			}
		}

		if ( ! is_user_logged_in() ) {

			$this->check_if_already_connected();


		}
	}

	public function check_if_already_connected() {

		global $ursc_response_global;


		if ( isset( $ursc_response_global['status'] ) && 'SUCCESS' === $ursc_response_global['status'] ) {

			if ( isset( $ursc_response_global['data'] ) && isset( $ursc_response_global['data']['email'] ) ) {

				$global_data = isset( $ursc_response_global['data'] ) ? $ursc_response_global['data'] : array();

				$network_data         = array(
					'email'     => isset( $global_data['email'] ) ? $global_data['email'] : '',
					'username'  => isset( $global_data['username'] ) ? $global_data['username'] : '',
					'profile'   => isset( $global_data['profile'] ) ? $global_data['profile'] : '',
					'network'   => isset( $ursc_response_global['network'] ) ? $ursc_response_global['network'] : '',
					'has_email' => ! empty( $global_data['email'] ) ? true : false,

				);
				$is_already_connected = URSC_Social_Data::is_already_connected_network( $network_data['username'], $network_data['network'], $network_data['email'] );

				if ( $is_already_connected ) {

					$status = URSC_Social_Data::check_user_and_login( $network_data );

					if ( is_wp_error( $status ) ) {

						$this->wp_error = $status;

					}
				}
			}
		}

	}

}

return new URSC_Frontend();
