<?php
/**
 * UserRegistrationSocialConnect Functions.
 *
 * General core functions available on both the front-end and admin.
 *
 * @author   WPEverest
 * @category Core
 * @package  UserRegistrationSocialConnect/Functions
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @return mixed
 */
function user_registration_social_login_templates() {

	$templates = apply_filters( 'user_registration_social_login_template', array(

		'ursc_theme_1' => sprintf( __( 'Style 1 %1$s', 'user-registration-social-connect' ), '<br/><img style="margin-top:10px;" src="' . URSC()->plugin_url() . '/assets/images/ursc_theme_1.jpg"/>' ),
		'ursc_theme_2' => sprintf( __( 'Style 2 %1$s', 'user-registration-social-connect' ), '<br/><img style="margin-top:10px;" src="' . URSC()->plugin_url() . '/assets/images/ursc_theme_2.jpg"/>' ),
		'ursc_theme_3' => sprintf( __( 'Style 3 %1$s', 'user-registration-social-connect' ), '<br/><img style="margin-top:10px;" src="' . URSC()->plugin_url() . '/assets/images/ursc_theme_3.jpg"/>' ),
		'ursc_theme_4' => sprintf( __( 'Style 4 %1$s', 'user-registration-social-connect' ), '<br/><img style="margin-top:10px;" src="' . URSC()->plugin_url() . '/assets/images/ursc_theme_4.jpg"/>' ),

	) );

	return $templates;
}

/**
 * @return mixed
 */
function user_registration_social_networks() {

	$networks = array(

		'facebook' => array(
			'enable_id'  => 'user_registration_social_setting_enable_facebook_connect',
			'key_id'     => 'user_registration_social_setting_facebook_app_id',
			'secret_id'  => 'user_registration_social_setting_facebook_app_secret',
			'login_text' => 'user_registration_social_login_with_facebook_text'
		),
		'twitter'  => array(
			'enable_id'  => 'user_registration_social_setting_enable_twitter_connect',
			'key_id'     => 'user_registration_social_setting_twitter_consumer_key',
			'secret_id'  => 'user_registration_social_setting_twitter_consumer_secret',
			'login_text' => 'user_registration_social_login_with_twitter_text'

		),
		'google'   => array(
			'enable_id'  => 'user_registration_social_setting_enable_google_connect',
			'key_id'     => 'user_registration_social_setting_google_client_id',
			'secret_id'  => 'user_registration_social_setting_google_client_secret',
			'login_text' => 'user_registration_social_login_with_google_text'

		),
		'linkedin' => array(
			'enable_id'  => 'user_registration_social_setting_enable_linkedin_connect',
			'key_id'     => 'user_registration_social_setting_linkedin_client_id',
			'secret_id'  => 'user_registration_social_setting_linkedin_client_secret',
			'login_text' => 'user_registration_social_login_with_linkedin_text'

		),

	);


	return apply_filters( 'user-registration-registered-social-networks', $networks );
}

/**
 * @param $key
 * @param $value
 */
function user_registration_social_connect_set_session( $key, $value ) {

	if ( session_status() === PHP_SESSION_NONE ) {
		session_start();
	}

	$_SESSION['user_registration_social_connect'][ $key ] = $value;

}

/**
 * @param $key
 * @param $value
 */
function user_registration_session_start() {

	if ( session_status() === PHP_SESSION_NONE ) {
		session_start();
	}

}

/**
 * @param $key
 */
function user_registration_social_connect_unset_session( $key ) {
	if ( session_status() === PHP_SESSION_NONE ) {
		session_start();
	}

	if ( isset( $_SESSION['user_registration_social_connect'] ) ) {

		if ( isset( $_SESSION['user_registration_social_connect'][ $key ] ) ) {

			unset( $_SESSION['user_registration_social_connect'][ $key ] );
		}
	}

}

/**
 * @param $key
 */

function user_registration_social_connect_get_session( $key ) {
	if ( session_status() === PHP_SESSION_NONE ) {
		session_start();
	}

	if ( isset( $_SESSION['user_registration_social_connect'] ) ) {

		if ( isset( $_SESSION['user_registration_social_connect'][ $key ] ) ) {

			return ( $_SESSION['user_registration_social_connect'][ $key ] );
		}
	}

	return false;

}

/**
 * @param $notices
 */
function ursc_admin_notices() {

	$class = 'notice notice-error';

	$message = ursc_is_compatible();

	if ( 'YES' !== $message ) {

		printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), ( $message ) );
	}
}

function ursc_check_plugin_compatibility() {

	add_action( 'admin_notices', 'ursc_admin_notices', 10 );

}

/**
 * @param bool $show_notice
 */
function ursc_is_compatible() {

	$plugins_path = WP_PLUGIN_DIR . URSC_DS . 'user-registration' . URSC_DS . 'user-registration.php';

	if ( ! file_exists( $plugins_path ) ) {

		return __( 'Please install <code>user-registration</code> plugin to use <code>user-registration-social-connect</code> addon.', 'user-registration-social-connect' );
	}
	$plugin_file_path = 'user-registration/user-registration.php';

	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	if ( ! is_plugin_active( $plugin_file_path ) ) {

		return __( 'Please activate <code>user-registration</code> plugin to use <code>user-registration-social-connect</code> addon.', 'user-registration-social-connect' );

	}
	if ( function_exists( 'UR' ) ) {

		$user_registration_version = UR()->version;

	} else {

		$user_registration_version = get_option( 'user_registration_version' );

	}

	if ( version_compare( $user_registration_version, '1.1.0', '<' ) ) {

		return __( 'Please update your <code>user-registration</code> plugin(to at least 1.1.0 version) to <code>use user-registration-social-connect</code> addon.', 'user-registration-social-connect' );

	}

	return 'YES';

}

/**
 * @param $redirect
 */
function ursc_custom_redirect( $redirect ) {
	if ( headers_sent() ) { // Use JavaScript to redirect if content has been previously sent (not recommended, but safe)
		echo '<script language="JavaScript" type="text/javascript">window.location=\'';
		echo $redirect;
		echo '\';</script>';
	} else { // Default Header Redirect
		header( 'Location: ' . $redirect );
	}
	exit;
}

function ursc_flush_all() {

	if ( session_status() === PHP_SESSION_NONE ) {
		session_start();
	}
	if ( isset( $_SESSION['user_registration_social_connect'] ) ) {

		unset( $_SESSION['user_registration_social_connect'] );

	}

	global $ursc_response_global;

	unset( $ursc_response_global );
}

/**
 * @return mixed
 */
function ursc_social_login_redirect() {

	return apply_filters( 'user_registration_social_connect_login_redirect', admin_url() );
}

/**
 * @param $session
 *
 * @return bool
 */
function ursc_check_network_session_exists( $session ) {

	if ( isset( $session['email'] ) && isset( $session['username'] ) && isset( $session['network'] ) && isset( $session['profile'] ) && isset( $session['has_email'] ) ) {

		return true;
	}

	return false;
}

/**
 * @param $session
 *
 * @return bool
 */
function ursc_has_matched_with_session( $session, $data ) {

	if ( ! ursc_check_network_session_exists( $session ) ) {

		return false;
	}
	if ( ! $session['has_email'] ) {

		$session['email'] = $data['email'];

	}
	unset( $session['has_email'] );

	$result = array_diff_assoc( $session, $data );


	return count( $result ) > 0 ? false : true;
}

/**
 * @return mixed
 */
function ursc_social_api_settings() {

	return apply_filters(
		'user_registration_social_settings', array(

			array(
				'title' => __( 'API settings', 'user-registration-social-connect' ),
				'type'  => 'title',
				'desc'  => '',
				'id'    => 'user_registration_social_options',
			),
			array(
				'row_class' => 'ursc_enable_disable ursc_facebook_enable',
				'title'     => __( 'Enable facebook ?', 'user-registration-social-connect' ),
				'desc'      => __( 'Tick here if you want to enable facebook login.', 'user-registration-social-connect' ),
				'id'        => 'user_registration_social_setting_enable_facebook_connect',
				'default'   => 'no',
				'type'      => 'checkbox',
				'autoload'  => false,
			),
			array(
				'row_class' => 'ursc_hidden ursc_facebook_app_id',
				'title'     => __( 'Facebook App ID', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get app id from  %1$s facebook %2$s.', 'user-registration-social-connect' ), '<a href="https://developers.facebook.com/apps/" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_facebook_app_id',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_hidden ursc_facebook_app_secret',
				'title'     => __( 'Facebook App secret', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get app secret from  %1$s facebook %2$s.', 'user-registration-social-connect' ), '<a href="https://developers.facebook.com/apps/" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_facebook_app_secret',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_enable_disable ursc_twitter_enable',
				'title'     => __( 'Enable twitter?', 'user-registration-social-connect' ),
				'desc'      => __( 'Tick here if you want to enable twitter login.', 'user-registration-social-connect' ),
				'id'        => 'user_registration_social_setting_enable_twitter_connect',
				'default'   => 'no',
				'type'      => 'checkbox',
				'autoload'  => false,
			),
			array(
				'row_class' => 'ursc_hidden ursc_twitter_consumer_key',
				'title'     => __( 'Twitter Consumer Key', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get Consumer Key from  %1$s twitter %2$s.', 'user-registration-social-connect' ), '<a href="https://apps.twitter.com/app/" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_twitter_consumer_key',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_hidden ursc_twitter_consumer_secret',
				'title'     => __( 'Twitter Consumer Secret', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get consumer secret from  %1$s twitter %2$s.', 'user-registration-social-connect' ), '<a href="https://apps.twitter.com/app/" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_twitter_consumer_secret',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_enable_disable ursc_google_enable',
				'title'     => __( 'Enable google?', 'user-registration-social-connect' ),
				'desc'      => __( 'Tick here if you want to enable google login.', 'user-registration-social-connect' ),
				'id'        => 'user_registration_social_setting_enable_google_connect',
				'default'   => 'no',
				'type'      => 'checkbox',
				'autoload'  => false,
			),
			array(
				'row_class' => 'ursc_hidden ursc_google_client_id',
				'title'     => __( 'Google Client ID', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get Client ID from  %1$s google %2$s.', 'user-registration-social-connect' ), '<a href="https://console.developers.google.com/apis/" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_google_client_id',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_hidden ursc_google_client_secret',
				'title'     => __( 'Google Client Secret', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get Client Secret from  %1$s google %2$s.', 'user-registration-social-connect' ), '<a href="https://console.developers.google.com/apis/" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_google_client_secret',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_enable_disable ursc_linkedin_enable',
				'title'     => __( 'Enable linkedin?', 'user-registration-social-connect' ),
				'desc'      => __( 'Tick here if you want to enable linkedin login.', 'user-registration-social-connect' ),
				'id'        => 'user_registration_social_setting_enable_linkedin_connect',
				'default'   => 'no',
				'type'      => 'checkbox',
				'autoload'  => false,
			),
			array(
				'row_class' => 'ursc_hidden ursc_linkedin_client_id',
				'title'     => __( 'Linkedin Client ID', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get Client ID from  %1$s linkedin %2$s.', 'user-registration-social-connect' ), '<a href="https://www.linkedin.com/developer/apps" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_linkedin_client_id',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'row_class' => 'ursc_hidden ursc_linkedin_client_secret',
				'title'     => __( 'Linkedin Client Secret', 'user-registration-social-connect' ),
				'desc'      => sprintf( __( 'Get Client Secret from  %1$s linkedin %2$s.', 'user-registration-social-connect' ), '<a href="https://www.linkedin.com/developer/apps" target="_blank">', '</a>' ),
				'default'   => '',
				'id'        => 'user_registration_social_setting_linkedin_client_secret',
				'type'      => 'text',
				'autoload'  => false,
				'desc_tip'  => true,
				'css'       => 'min-width: 350px;',


			),
			array(
				'type' => 'sectionend',
				'id'   => 'user_registration_social_options',
			),


		)
	);

}

/**
 * @return mixed
 */
function ursc_social_advance_settings() {

	return apply_filters(
		'user_registration_other_social_settings', array(

			array(
				'title' => __( 'Advance Settings', 'user-registration-social-connect' ),
				'type'  => 'title',
				'desc'  => '',
				'id'    => 'user_registration_social_advance_options',
			),
			array(
				'title'    => __( 'Enable social registration ?', 'user-registration-social-connect' ),
				'desc'     => __( 'Tick here if you want to enable social registration', 'user-registration-social-connect' ),
				'id'       => 'user_registration_social_setting_enable_social_registration',
				'default'  => 'no',
				'type'     => 'checkbox',
				'autoload' => false,
			),
			array(
				'title'    => __( 'Default user role', 'user-registration-social-connect' ),
				'desc'     => __( 'This option lets you choose user role for social registration.', 'user-registration-social-connect' ),
				'id'       => 'user_registration_social_setting_default_user_role',
				'default'  => 'subscriber',
				'type'     => 'select',
				'class'    => 'ur-enhanced-select',
				'css'      => 'min-width: 350px;',
				'desc_tip' => true,
				'options'  => ur_get_default_admin_roles(),
			),
			array(
				'title'    => __( 'Social login templates', 'user-registration-social-connect' ),
				'desc'     => __( 'Select template for social login', 'user-registration-social-connect' ),
				'default'  => 'ursc_theme_4',
				'id'       => 'user_registration_social_login_template',
				'type'     => 'radio',
				'autoload' => false,
				'desc_tip' => true,
				'options'  => user_registration_social_login_templates()


			),

			array(
				'type' => 'sectionend',
				'id'   => 'user_registration_social_advance_options',
			),
			array(
				'title' => __( 'Social Text', 'user-registration-social-connect' ),
				'type'  => 'title',
				'desc'  => '',
				'id'    => 'user_registration_social_advance_text_options',
			),
			array(
				'title'    => __( 'Login with facebook text', 'user-registration-social-connect' ),
				'desc'     => __( 'Login with facebook string.', 'user-registration-social-connect' ),
				'default'  => __( 'Login with facebook', 'user-registration-social-connect' ),
				'id'       => 'user_registration_social_login_with_facebook_text',
				'type'     => 'text',
				'autoload' => false,
				'desc_tip' => true,
				'css'      => 'min-width: 350px;',


			),
			array(
				'title'    => __( 'Login with twitter text', 'user-registration-social-connect' ),
				'desc'     => __( 'Login with twitter string.', 'user-registration-social-connect' ),
				'default'  => __( 'Login with twitter', 'user-registration-social-connect' ),
				'id'       => 'user_registration_social_login_with_twitter_text',
				'type'     => 'text',
				'autoload' => false,
				'desc_tip' => true,
				'css'      => 'min-width: 350px;',


			),
			array(
				'title'    => __( 'Login with google text', 'user-registration-social-connect' ),
				'desc'     => __( 'Login with google string.', 'user-registration-social-connect' ),
				'default'  => __( 'Login with google', 'user-registration-social-connect' ),
				'id'       => 'user_registration_social_login_with_google_text',
				'type'     => 'text',
				'autoload' => false,
				'desc_tip' => true,
				'css'      => 'min-width: 350px;',


			),
			array(
				'title'    => __( 'Login with linkedin text', 'user-registration-social-connect' ),
				'desc'     => __( 'Login with linkedin string.', 'user-registration-social-connect' ),
				'default'  => __( 'Login with linkedin', 'user-registration-social-connect' ),
				'id'       => 'user_registration_social_login_with_linkedin_text',
				'type'     => 'text',
				'autoload' => false,
				'desc_tip' => true,
				'css'      => 'min-width: 350px;',


			),

			array(
				'type' => 'sectionend',
				'id'   => 'user_registration_social_advance_text_options',
			),


		)
	);

}
