<?php

/**
 * WordPress ScratchIt
 * http://devplus31.com/wpscratchit
 * 1.0.0
 * DevPlus31
 */
class WPScratch_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @var      string    $plugin_name       The name of this plugin.
	 * @var      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

		require_once plugin_dir_path( dirname(__FILE__) ) . 'includes/class-wpscratch-options.php';
		
		add_action('admin_menu', function()
		{
			WP_ScratchIt_Options::setup_page_options();

		});

		add_action('admin_init', function()
		{
			new WP_ScratchIt_Options();

		});

	// 	add_action('wp_dashboard_setup', new ScratchIt_DashboardWidget());
	//s	do_action('wp_dashboard_setup');

		add_action( 'wp_ajax_remove_scratch_entry', ['ScratchIt_Entries', 'remove_scratch_entry'] );
		add_action( 'wp_ajax_nopriv_remove_scratch_entry', array('ScratchIt_Entries', 'remove_scratch_entry') );

        add_action( 'wp_ajax_reset_history_entry', ['WP_ScratchIt_Options', 'remove_scratch_entry'] ); // Global
        add_action( 'wp_ajax_nopriv_reset_history_entry', array('WP_ScratchIt_Options', 'remove_scratch_entry') ); // Global


	}

	/**
	 * Register the stylesheets for the Dashboard.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Plugin_Name_Admin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Plugin_Name_Admin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/wpscratch.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the dashboard.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Plugin_Name_Admin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Plugin_Name_Admin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_media();
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/wpscratch.js', array( 'jquery', 'wp-color-picker' ), $this->version, false );

	}

}
