(function( $ ) {
	'use strict';
	$(function() {
		$('#wp_scratchit_values .panel-item-bar').click(function(e)
		{
			OnChangeTab(this);
		});

		function OnChangeTab(element) {
			var id = $(element).attr('data-id');
			$('.active-btn-panel').removeClass('active-btn-panel');
			$(element).addClass('active-btn-panel');
			$('.tabs-content .tab-content').removeClass('tab-active');
            $('.tabs-content .tab-content[data-id="'+ id +'"]').addClass('tab-active');
		}

		function htmlTemplate(id) {
			var html = $('.hidden-template').html();
			var content = '<div class="tab-content" data-id="'+id+'">'+ html +'</div>';
			content = content.replace(new RegExp('card_ID', 'g'), 'card_'+id);
			$('.tabs-content').append(content);
		}

		$('.scratch-tab-new .icon').click(function(e)
		{
			var num = $('.tabs .panel-item-bar').length + 1;
			var element = '<div class="panel-item-bar" data-id="'+num+'">'+ num +'</div>';
			$('.tabs').append(element);
			element =  $('.tabs .panel-item-bar[data-id="'+num+'"]');
			$(element).bind('click', function() {
				OnChangeTab(element);
			});
			htmlTemplate(num);
		});

		function onUploadBtnClick() {
			// var textFieldId = $(this).prev().attr('id');
			// console.log(textFieldId);
			var base = this;
			wp.media.editor.send.attachment = function(props, attachment)
			{
				$(base).prev().val(attachment.url);
			};
			wp.media.editor.open(this);
			return false;
		}

		$(document).on('click', '.upload_image_btn', onUploadBtnClick);

		$('.meta-color').wpColorPicker();
		$('.tabs .tab-links a').on('click', function(e)  {
	        var currentAttrValue = jQuery(this).attr('href');
	        // Show/Hide Tabs
	        jQuery('.tabs ' + currentAttrValue).show().siblings().hide();
	        e.preventDefault();
	    });



		$('.scratchit_remove_entries').click(function(e) {
			var base = this;
			if (confirm("You're going to delete this entry")) {
				$.ajax({
					url: ajaxurl,
					type: 'post',
					data: {
						action: 'remove_scratch_entry',
						post_id: $(base).attr('data-id')
					},
					success: function (response) {
						$(base).parents('tr').css({'background': 'red'}).fadeOut(2500);

					//	window.location.reload();
					}
				});

			}
		});

		$('.reset_history').click(function(e) {
			$.ajax({
				url: ajaxurl,
				type:'post',
				data: {
					action: 'reset_history_entry'
				},
				success: function(response) {
					if (response != undefined) {
							alert('Database cleaned...');
					}
				}
			});
			e.preventDefault();
		});

		$('.card_preview').hover(function(){
			$(this).children('.card_preview_picture').css({display: 'block'});
		});

		$('.card_preview').mouseleave(function() {
            $(this).children('.card_preview_picture').css({display: 'none'});
		})

		$('.click_reset_winners').click(function(e){
			if (confirm("Are you sure that you do want to reset the list of winners"))
			{
                $.ajax({
                    url: ajaxurl,
                    type:'post',
                    data: {
                        action: 'reset_post_winners',
						postId: $(this).data('id')
                    },
                    success: function(response) {
                        if (response != undefined) {
                            alert('Done...');
                        }
                    }
                });
                e.preventDefault();
			}
		});

		// Admin UI (trigger date input)
		$('.wp_scratch_expire_on_select').change(function(){

			var selected = false;
			if ($('.wp_scratch_expire_on_select option:selected').val() === 'date')
				selected = true;

			if (selected) {
                $('.wp_scratch_expire_on_date').css({'display': 'block'});
			}
			else
			{
				$('.wp_scratch_expire_on_date').css({'display': 'none'});
			}

		});

        if ($('.wp_scratch_expire_on_select option:selected').val() === 'date')
		{
            $('.wp_scratch_expire_on_date').css({'display': 'block'});
		}

	});
})( jQuery );