<?php

/**
 * Created by PhpStorm.
 * User: DevPlus31
 * Date: 10/06/2016
 * Time: 18:38
 */

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class ScratchIt_Entries extends WP_List_Table
{
    /**
     * @var
     */
   //public $items;

    /**
     * ScratchIt_Entries constructor.
     * @param null $args
     */
    public function __construct($args = null)
    {

        parent::__construct(array(
               'singular' => __('Scratch card entry'),
                'plural'  => __('Scratch card entries'),
                'ajax'    => false
            ));
        $this->prepare_items();
    }

    public static function remove_scratch_entry()
    {
        $id = filter_var($_POST['post_id'], FILTER_VALIDATE_INT);
        $entry = new User_ScratchIt_Data();
        $entry->removeUserScratchByID($id);
        return json_encode(array('success' => 1));
    }

    /**
     * @return array
     */
    public function get_columns()
    {
        return array(
            'cb' => '<input type="checkbox" />',
            'user' => __('User'),
            'card' => __('Card'),
            'position' => __('Card Position'),
            'date'  => __('Date'),
            'action' => __('Action')
        );
    }

    public function get_bulk_actions()
    {
        if (isset($this->_args['bulk']) && $this->_args['bulk'] == false)
            return;

        return array(
            'to_remove' => __('Remove')
        );
    }

    public function process_bulk_action()
    {
        if (isset($_POST['_wpnonce']) && ! empty($_POST['_wpnonce'])) {
            $nonce = filter_input( INPUT_POST, '_wpnonce', FILTER_SANITIZE_STRING);
            $action = 'bulk-'.$this->_args['plural'];

            if (! wp_verify_nonce($nonce, $action))
                die("You're not allowed to do this action");
        }

        $actions = $this->get_bulk_actions();
        if (!is_array($actions)) return;


        if (in_array($this->current_action(), array_keys($actions)))
        {
            $entries = isset($_POST['entries']) ? $_POST['entries']: null;
            // Delete Scratch Entry
            $user = new User_ScratchIt_Data(); 
            foreach($entries as $entry) {
                $user->removeUserScratchByID($entry);
            }
        }
    }

    /**
     * @param $item
     * @return string
     */
    public function column_cb($item)
    {
        return sprintf('<input type="checkbox" name="entries[]" value="%s" />', $item->id);
    }

    /**
     * @param $item
     * @return string
     */
    public function column_id($item)
    {
     //   return '<strong>' . $item->id .  '</strong>';
    }

    /**
     * @param $item
     * @return string
     */
    public function column_date($item)
    {
        $date = DateTime::createFromFormat('Y-m-d H:i:s', $item->at_time);
        return '<abbr title="'.$item->at_time.'">' .  $date->format('Y-m-d') .'</abbr>';
    }

    /**
     * @param $item
     * @return string
     */
    public function column_user($item)
    {
        if (filter_var($item->ipAddress, FILTER_VALIDATE_IP) && $item->user_id == 0) {
            echo '<p>'. $item->ipAddress.'</p>';
        }
        else
        {
            $user = get_user_by( 'ID', $item->user_id);
            echo '<p>'. $user->display_name .'</p>';
            echo '<div class="row-actions">';
            echo '<a href="'.get_edit_user_link($user->ID).'">'.__('Check Profile').'<a>';
            echo '</div>';
        }

    }

    /**
     * @param $item
     * @return string
     */
    public function column_card($item)
    {
        $post_id = $item->value_id;
        $post = get_post($post_id);
        if ($post) {
            echo "<p>$post->post_title</p>";
            echo '<div class="row-actions">';
            edit_post_link(__('Edit'), null,null,$post->ID);
            echo '</div>';
            return;
        }
        return null;
    }

    /**
     * @param $item
     * @return string
     */
    public function column_position($item)
    {
        $post_id = $item->value_id;
        $card = Scratch_CardCollection::PeekCard($item->value, get_post_meta($post_id, WPScratchIt_Posts::$cards_meta_key, true));
        return "<p class='card_preview'>$item->value <img class='card_preview_picture' src=".$card->getGeneratedImage()."></p>";
    }

    public function column_action($item)
    {
        return "<a href='javascript:void(0)' data-id='".$item->id."' class='scratchit_remove_entries'>". __('Delete') ."</a>";
    }

    public function no_items()
    {
        _e('No Entries available.');
    }

    /**
     * Prepare Items
     */
    public function prepare_items()
    {

        global $wpdb;
        $table = $wpdb->prefix . 'wp_scratchit';

        if (isset($_POST['search']))
        {
            $username = filter_var($_POST['search'], FILTER_SANITIZE_STRING);
            $username_id  = $username;
           // $list = $wpdb->get_results("SELECT * FROM $table WHERE user_id = ");
            $list = $wpdb->query( $wpdb->prepare("SELECT * FROM $table WHERE user_id = %d", $username_id));

        }
        else
        {
            $list = $wpdb->get_results("SELECT * FROM $table");
        }


        $this->_column_headers = array($this->get_columns(), array(), array());
        $this->items = $list;

        $this->process_bulk_action();
    }

}