<?php
define('WPSCRATCHIT_JAL_DB_VERSION', 2.0);
/**
 * WordPress ScratchIt
 * http://devplus31.com/wpscratchit
 * DevPlus31
 */
class WPScratch_Activator {


	protected $table = "wp_scratchit";

	/**
	 * Register default settings
	 * @since    1.0.0
	 */
	public static function activate() {

		$defaults = [
					'wp_scratchit_scratchafter'    => 75,
					'wp_scratchit_radius_size'     => 15,
					'wp_scratchit_color'           => '#9b9b9b',
					'wp_scratchit_foreground'      => plugins_url( 'public/img/scratch.jpg' , dirname(__FILE__)),
					'wp_scratchit_icon'            => plugins_url( 'public/img/coin.png' , dirname(__FILE__)),
					'wp_scratchit_save_values'     => true,
                    'wp_scratchit_only_once' => false,
					'wp_scratchit_clean'           => true,
					'wp_scratchit_allow_anonymous' => true
			];

		add_option('wp_scratchit_options', $defaults, '', 'yes');


		$instance = new static();

        if ( get_site_option( 'wpscratchit_jal_db_version' ) != WPSCRATCHIT_JAL_DB_VERSION ) {
            $instance->createUpdateTable();
            update_site_option('wpscratchit_jal_db_version', WPSCRATCHIT_JAL_DB_VERSION);
        }
	}

    /**
     * WPScratch_Activator constructor.
     */
	public function __construct()
	{
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        add_action( 'plugins_loaded', [$this, 'myplugin_update_db_check']);
	}

    /**
     * Creates Tables
     */
	public function createUpdateTable()
	{
		global $wpdb;
		// Create Table if Don't Exists
		$table_name = $wpdb->prefix . $this->table;
	//	$charset = $wpdb->get_charset_collate();

    	// `istemp` BOOLEAN NOT NULL

		$sql = "CREATE TABLE `$table_name` (
          id int(10) unsigned NOT NULL AUTO_INCREMENT,
          user_id int(10) unsigned NOT NULL,
          value text NOT NULL,
          last_value text,
          value_id int(10) unsigned NOT NULL,
          at_time datetime DEFAULT NULL,
          ipAddress varchar(32) DEFAULT '' NOT NULL, 
          PRIMARY KEY (id)
        )";

		dbDelta($sql);

	}


    /**
     * Check if table exists
     * @return bool
     */
	/*public function check()
	{
		global $wpdb;

		$table_name = $wpdb->prefix . $this->table;
		$charset = $wpdb->get_charset_collate();

		$sql = "SHOW TABLES LIKE '".$table_name."'";
		$result = dbDelta($sql);
		if (count($result) > 0)
			return true;
		return false;
	}*/

    function myplugin_update_db_check() {
        if ( get_site_option( 'wpscratchit_jal_db_version' ) != WPSCRATCHIT_JAL_DB_VERSION ) {
           $this->createUpdateTable();
           update_site_option('wpscratchit_jal_db_version', WPSCRATCHIT_JAL_DB_VERSION);
        }
    }


}

