<?php 

/**
 * WordPress ScratchIt
 * @url http://devplus31.com/wpscratchit
 * @version 2.0
 * @author DevPlus31
 */

class ImageGen {

	/**
	* The output file path
	* @var string
	*/
	private $filename;

	/**
	* The Generated Image Width
	* @var integer
	*/
	private $width;
	
	/**
	* The Generated Image Height
	* @var integer
	*/
	private $height;
	
	/**
	* The Content
    * @var string
	*/
	private $content;
	
	/**
	* The font Path
	* @var string
	*/
	private $font;
	
	/**
	 * The font size
	 * @var integer
	 */
	private $fontSize;
	
	/**
	 * The Base Path (URL)
	 */
	private $basepath;
	
	/**
	 * URL to the Base Image
	 * @var string
	 */
	private $baseImagePath;

	/**
	 * Text Position
	 * @var string
	 */
	private $position;

	/**
     * Text Color
	 * @var string
	 */
	private $fontColor;

	/**
	 *  class constructor
	 * @param $filename
	 * @param $width
	 * @param $height
	 * @param $font
	 * @param $text
	 * @param $basepath
	 * @param null $baseImagePath
	 * @param int $fontsize
	 */
	public function __construct($filename, $width, $height, $font, $text, $basepath, $baseImagePath = null, $fontsize = 14)
	{
		$this->width   = $width; 
		$this->height  = $height;
		$this->content = $text;
		$this->font    = $font;
		$this->fontSize = $fontsize;
		$this->filename = $filename;
		$this->basepath = $basepath;
		$this->baseImagePath = $baseImagePath;
	}

    /**
     * Set a Text content to the Image
     * @param $text
     */
	public function setContent($text)
	{
		$this->content = $text;
	}

    /**
     * Set a Base Path
     * @param $text
     */
	public function setBasePath($text)
	{
		$this->basepath = $text;
	}	

	/**
	 * Set a Base Background Image Path
	 * @var string
	 * @return null
	 */
	public function setBaseImagePath($path)
	{
		$this->baseImagePath = $path;
	}

    /**
     * @param $size
     */
    public function setFontSize($size)
	{
		$this->fontSize = $size;
	}

    /**
     * @param $pos
     */
    public function setTextPosition($pos)
	{
		$this->position = $pos;
	}

    /**
     * @param $color
     */
    public function setFontColor($color)
	{
		$this->fontColor = $color;
	}

    /**
     * @return null|resource
     */
    private function loadImage()
	{
		if ($this->baseImagePath === null)
			return null;

		return imagecreatefromjpeg($this->baseImagePath);
	}

	/*private function getTextPositionCoords()
	{
		
	}*/

    /**
     * Convert Hex Color To RGB
     * @param $hex
     * @return array
     */
	private function convertHexToRGB($hex)
	{

	    $hex = str_replace("#", "", $hex);
	    if(strlen($hex) == 3) {

	      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
	      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
	      $b = hexdec(substr($hex,2,1).substr($hex,2,1));

	    } 
	    else 
	    {
	    
	      $r = hexdec(substr($hex,0,2));
	      $g = hexdec(substr($hex,2,2));
	      $b = hexdec(substr($hex,4,2));
	    }
	    
	    $rgb = array($r, $g, $b);
	    return $rgb; 
	}

	/**
	 * Get Image
	 *
	 */
	public function getImage()
	{
		// Load the Base Image
		$image = $this->loadImage();
		if ($image != null)
		{
			// Update Height and Width
			$this->width  = imagesx($image); 
			$this->height = imagesy($image);
		}
		else
		{
			$image = imagecreate($this->width, $this->height);
		}

		if (!$image)
		{
			return;
		}

		if (!$this->fontSize)
		    $this->fontSize = 14;

		$background = imagecolorallocate($image, 255, 255, 255);


        if ($this->fontColor)
		{
			$rgb = $this->convertHexToRGB($this->fontColor); 
			$textcolor = imagecolorallocate($image,  $rgb[0], $rgb[1], $rgb[2]);
		}
		else
		{
			$textcolor  = imagecolorallocate($image, 0, 0, 0); 	
		}

		
		$this->font = plugin_dir_path( dirname(__FILE__) ) . '/public/font/' . $this->font;
		$box = imagettfbbox($this->fontSize, 0, $this->font, $this->content);

		$c = abs($box[4] - $box[6]);
		$d = abs($box[3] - $box[5]);

		$x = ($this->width  - $c) / 2;
		$y = ($this->height - $d) / 2;

		if (imagettftext($image, $this->fontSize, 0, $x, $y, $textcolor, $this->font, $this->content))
		{
			imagepng($image, $this->filename);
			imagedestroy($image);
			str_replace('\\', '/', $this->filename);
			$parts = explode('/', $this->filename);
			return wp_upload_dir()['baseurl'] . $this->basepath . '/' . array_pop($parts);
		}

	}
}


/**
 * Class ImageGeneratorManager
 */
class ImageGeneratorManager
{

    /**
     * Content
     * @var
     */
    private $data;
    /**
     * Options
     * @var
     */
    private $options;
    /**
     * ImageGen Handler
     * @var
     */
    private $ImageGen;
    /**
     * Scratch Contents Collection
     * @var
     */
    private $contents;

	/**
	 * @param $content
	 * @param $args
	 * @internal param $data
	 * @internal param $options
	 */
	public function __construct($content, $args)
	{
		$this->data = $content;
		$this->options = $args;
		// $this->ImageGen = new ImageGen($content,$args['width'], $args['height'], $args['font'], $content, $args['basepath']);
	}

    /**
     * @param $content
     * @param $options
     * @return string
     */
    public static function getImageUrl($content, $options)
	{
		return (new ImageGeneratorManager($content, $options))->getUrl();
	}

	/**
	 * @param array $contents
     */
	public function setCollection(array $contents)
	{
	   $this->contents = $contents;
	}

    /**
     * @param array $contents
     * @return array
     */
    public function getCollectionUrls(array $contents)
	{
		if (is_null($this->contents))
		{
			$this->setCollection($contents);
		}

		$urls = [];
		foreach($this->contents as $item)
		{
			$urls[] = $this->getUrl($item);
		}

        return $urls;
	}

    /**
     * @param $item
     * @return string
     */
    public function getUrl($item)
	{
		$background = $this->options['background'];
		var_dump($background);
		$file = $item['path'] . $item['value'] .'_Post.png';
		$content = $item['post_content'] . PHP_EOL . $item['content'];
		$this->ImageGen = new ImageGen($file, $item['width'], $item['height'], $item['font'], $content, $item['basepath']);
		return $this->ImageGen->getImage();
	}

	public function getBase64($imagePath)
    {
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $type = $finfo->file($imagePath);
        return 'data:'.$type.';base64,'.base64_encode(file_get_contents($imagePath));
    }

    /**
     * @param $key
     * @return null
     */
    private function get($key)
	{
		return (isset($this->options[$key])) ? $this->options[$key] : null;
	}
}