<?php

/**
 * WordPress ScratchIt
 * http://devplus31.com/wpscratchit
 * DevPlus31
 */

class ShortCodeHandler {

    /**
     * Draw the scratch
     * @param $attrs
     * @param null $content
     * @return null|string
     */
    public function wp_scratch_show_scratch($attrs, $content = null)
	{
		$post_id = 0;
		if (isset($attrs['title']))
		{
			$title = $attrs['title'];
		}
		elseif (isset($attrs['id']))
		{
			$post_id = (int)$attrs['id'];
		}
		else
		{
			return;
		}

		if (isset($title))
		{
			global $wpdb; 
			$post_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_title = %s", $title));
		}

		$options = get_option('wp_scratchit_options');
		if ($options['wp_scratchit_allow_anonymous'] == FALSE && !is_user_logged_in())
		{
			echo '<p>Please you must be logged in</p>';
			exit;
		}

        $winners = get_post_meta($post_id, 'wp_scratch_user_winners', true);
        $max_winners = get_post_meta ($post_id, 'wp_scratchit_meta_max_winners', true);
        $expires_on = get_post_meta($post_id, 'wp_scratchit_meta_expires_on', true);

        if ($expires_on === 'all_over')
        {
            if ($max_winners != 0 && (count(json_decode($winners)) === (int)$max_winners)) {
                $this->expired();
            }
        }
        else if ($expires_on === 'date')
        {
            $expires_date = strtotime(get_post_meta($post_id, 'wp_scratchit_meta_expires_date', true));
            $date = time();
            if ($date >= $expires_date)
            {
                $this->expired();
            }
        }

        $cards = new WP_ScratchIt_CardsGetter($post_id, $options);
		$card = $cards->get();

		// var_dump($card->getText());

		if ($card->getBackground() && empty($card->getText())) {
			$background = $card->getBackground(); 
		}
		else
		{
			$background = $card->getGeneratedImage();
		}

		$foreground = get_post_meta($post_id, 'wp_scratchit_meta_foreground', true);
		$foreground = (empty($foreground) ? $options['wp_scratchit_foreground'] : $foreground);

	//	$background = $this->getDataURI($background);
	//	var_dump($background);

		// Security: Just for not publishing the post ID
		$hpost_id = sha1($post_id + 1359);
		ob_start();
		?>
			<div class="scratch" id="scratch_<?= $hpost_id ?>"></div>				
				<script>
				new ScratchIt(document.getElementById('scratch_<?= $hpost_id ?>'), {
	                        'background': '<?=  $background; ?>',
	                        'foreground': '<?= $foreground; ?>',
	                        'coinImage': '<?= $options["wp_scratchit_icon"] ?>',
	                        'scratchAfter': '<?= $options["wp_scratchit_scratchafter"] ?>',
	                        'radius': '<?= $options["wp_scratchit_radius_size"] ?>',
	                        'id' : '<?= ($post_id + 49686) ?>',
	                        'redirectUrl': '<?= $card->getRedirectLink(); ?>',
	       		});
				</script>
		<?php
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}

	public function expired()
    {
        ?>
        <p>Unfortunately this ScratchCard has been expired!</p>
        <?php
        exit;
    }

}

/**
 * Class WP_ScratchIt_CardsGetter
 */
class WP_ScratchIt_CardsGetter
{

    /**
     * Post ID
     * @var
     */
    protected $postId;

    /**
     * Posts Options
     * @var
     */
    protected $options;


    /**
     * Default Post Text Size
     * @var
     */
    protected $defaultTextSize;


    /**
     * Default Post Text Color
     * @var
     */
    protected $defaultTextColor;

    /**
     * General Options
     * @var
     */
    protected $defaultOptions;


	/**
	 *
	 */
	protected $user_meta;

    /**
     * @param $postId
     * @param $options
     */
    public function __construct($postId, $options)
    {
        $this->postId = $postId;
        $this->options = $options;
        $this->defaultOptions = get_option('wp_scratchit_options');
		$this->user_meta = new User_ScratchIt_Data();
    }

    /**
     *
     */
    private function availableWinnersCount()
    {
        $max_winners = get_post_meta($this->postId, 'wp_scratchit_meta_max_winners', true);

        if ($max_winners == 0)
            return TRUE;

        $current_winners_count = count(json_decode(get_post_meta($this->postId, 'wp_scratch_user_winners', true)));
        return ($max_winners - $current_winners_count);
    }

	private function getAll()
	{
		$json = get_post_meta($this->postId, 'wp_scratchit_post_cards', true);
		$cards = new Scratch_CardCollection();
		$cards->ParseJson($json);
		return $cards;
	}

    /**
     * @param bool $save
     * @return mixed|null
     */
    public function get($save=false)
    {
		$cards = $this->getAll();
		$user = wp_get_current_user();
		// Check if the Scratch is limited
        $allow_anonymous = $this->getFromOption("wp_scratchit_allow_anonymous");

		$storedCard = isset($_SESSION['preUserResult']) ? $_SESSION['preUserResult'] : null;

		if ($storedCard)
		{
			extract($storedCard); // Extract postId and cardId
			if ($this->postId == $postId)
			{
				$card = $cards->Peek($cardId);
				if (is_user_logged_in() && $save) {
					$this->user_meta->saveUserResult($user->ID, $this->postId, $card->getID(), $ipAddress);
				}
				else {
				    if ($save && $allow_anonymous ){
                        $this->user_meta->saveUserResult(0,$this->postId, $card->getID(), $ipAddress); // Anonymous: IP will be used
                    }
                }
				return $card;
			}
			else
			{
				$_SESSION['preUserResult'] = null;
			}
		}


		if (is_user_logged_in())
		{
			if ($this->getFromOption('wp_scratchit_only_once') == TRUE )
			{
				//add_user_meta($user->ID, 'wp_scratchit_scratched', ['post_Id' => $this->postId, 'value' => '', 'background' => '', 'is_scratched' => FALSE]);
				if ($this->user_meta->hasUserScratch($user->ID, $this->postId)) // Check If user has already scratched
				{
					$value = $this->user_meta->getUserResult($user->ID, $this->postId);
					$card = $cards->Peek($value[0]->value);
					return $card;
				}
			}
		}

		//

		$winning_cards= [];
		$otherCards = [];
		foreach($cards->getItems() as $card)
		{
			if ($card->getIsWinningValue())
			{
				$winning_cards[] = $card;
			}
			else
			{
				$otherCards[] = $card;
			}
		}

		$result = [];
		$k = 10;
        $nb = ceil($k/2.5);
		foreach($otherCards as $card) {
			$cards = [];
			for($i = 0; $i < $k; $i++) {
				$cards[$i] = $card;
			}
			$result = array_merge($result, $cards);
		}

		if ($this->availableWinnersCount())
        {
            if (count($winning_cards)) {
                foreach($winning_cards as $card) {
                    $cards = [];
                    for($i = 0; $i < $nb ; $i++) {
                        $cards[$i] = $card;
                    }
                    $result = array_merge($result, $cards);
                }
            }
        }

        shuffle($result);
		$card = $result[array_rand($result, 1)];


		if (is_user_logged_in() && $this->getFromOption('wp_scratchit_save_values'))
		{
			// Save Value
			if (!isset($_SESSION['preUserResult'])) {
				$_SESSION['preUserResult'] = ['userId' => $user->ID, 'postId' => $this->postId, 'cardId' => $card->getID(), 'ipAddress' => $_SERVER['REMOTE_ADDR']];
			}

            if ($card->getIsWinningValue())
            {
                if (get_post_meta($this->postId, 'wp_scratch_user_winners', true))
                {
                    $winners = json_decode(get_post_meta($this->postId, 'wp_scratch_user_winners', true));
                }

                $max_winners = (int)get_post_meta ($this->postId, 'wp_scratchit_meta_max_winners', true);

                if (!isset($winners))
                {
                    $winners = [];
                }

                if ($max_winners === 0 || count($winners) < $max_winners)
                {
                    $new_winner = array('user' => $user->ID, 'postId' => $this->postId, 'cardPosition' => $card->getID());

                    if (count($winners) == 0) {
                        $winners = [$new_winner];
                    }
                    else
                    {
                        $winners = array_merge($winners, [$new_winner]);
                    }
                    update_post_meta($this->postId, 'wp_scratch_user_winners', json_encode($winners));
                }
            }

        }
        else if ($this->getFromOption('wp_scratchit_save_values'))
        {
            if (!isset($_SESSION['preUserResult'])) {
                $_SESSION['preUserResult'] = ['userId' => 0, 'ipAddress' => $_SERVER['REMOTE_ADDR'], 'postId' => $this->postId, 'cardId' => $card->getID()];
            }
        }

		// Check Card if is a Winning Value
		return $card;
    }

    /**
     * @param $key
     * @return null
     */
    protected function getFromOption($key)
    {
        if (isset($this->options[$key]))
        {
            return $this->options[$key];
        }
        return null;
    }

}