<?php

/**
 * User: DevPlus31
 * Date: 11/07/2015
 * Time: 00:43
 * version: 1.5
 * WP Key: wp_scratchit_post_cards
 */
class WPScratchIt_Posts
{
    /**
     * WP ScratchIt Posts Constructor
     */
    public function __construct()
    {
        $this->register_custom_post_type();
        $this->register_custom_fields();
        $this->register_custom_columns();

        add_action('before_delete_post', array($this, 'registerOnBeforeDeletePost'));
        add_action('admin_menu', array($this, 'add_entries_page'));
        add_action('wp_ajax_reset_post_winners', array($this, 'resetWinnerMaximumUser'));
    }

    /**
     * @var string
     */
    public static $cards_meta_key = 'wp_scratchit_post_cards';
    /**
     * @var string
     */
    public static $posts_winners_metakey = 'wp_scratch_user_winners';

    /**
     * Reset for All Posts
     */
    public static function resetAllPostsWinnersMeta()
    {
        $args = array( 'post_type' => 'wp_scratchit');
        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) : $loop->the_post();
            update_post_meta(get_the_ID(), static::$posts_winners_metakey, null);
        endwhile;
    }


    /**
     * Register Custom Post Type
     */
    private function register_custom_post_type()
    {
        register_post_type('wp_scratchit', [
            'labels' => [
                'name' => __('Scratch Cards'),
                'singular_name' => __('Scratch'),
                'add_new' => __('Add New Scratch Card'),
                'add_new_item' => __('Add New Scratch Card'),
                'edit_item' => __('Edit Item'),
                'new_item' => __('Add New Item'),
                'view_item' => __('View Scratch'),
                'search_items' => __('Search Scratch Cards'),
                'not_found' => __('No Scratch card Found'),
                'not_found_in_trash' => __('No Scratch card Found in Trash'),
                'menu_name' => __('Scratch Cards')
            ],
            'query_var' => false,
            'menu_icon' => 'dashicons-images-alt',
            'public' => true,
            'supports' => [
                'title',
                'editor',
                'custom_fields'
            ] 
        ]);
    }

    public function add_entries_page()
    {
        add_submenu_page('edit.php?post_type=wp_scratchit',
            'Scratch card entries',
            'Scratch card entries',
            'manage_options',
            'scratch-entries',
            'scratch_entries_callback'
            );

            function scratch_entries_callback()
            {
                ?>
                <style>
                    .card {
                        border:0;
                        background: inherit;
                    }
                </style>
                <div class="wrap">
                <form action="" method="post">
                <?php

                $entries = new ScratchIt_Entries();
                echo "<h1>" . __('Scratch History') ."</h1>";
                ?>
               <!-- <form method="post">
                    <input type="hidden" name="page" value="scratch-entries">
                    <p class="search-box">
                        <label class="screen-reader-text" for="search_id-search-input"></label>
                        <input type="text" id="search_id-serach-input" name="search" value="" placeholder="Search" />
                        <input type="submit" id="search-submit" class="button" name="" value="Search" />
                    </p>
                </form> !-->

                <?php
                $entries->prepare_items();
                $entries->display();

                ?>
                </form>
                </div>
                <script>

                </script>

                <?php
            }
    }

    public function registerOnBeforeDeletePost($post_id)
    {
        global $post_type;
        if ($post_type != 'wp_scratchit')
            return;
        Scratch_CardCollection::DestroyAll($post_id);
        $this->resetWinnerMaximumUser($post_id);

    }

    /**
     *
     */
    public function resetWinnerMaximumUser($post_id=null)
    {
       global $post;
       if (is_null($post_id)) {
            $post_id = $post->ID;
       }

      if ( isset($_POST['postId'])) { $post_id= (int)$_POST['postId']; }
       update_post_meta($post_id, static::$posts_winners_metakey, '');
    }

    /**
     * Register Columns For CRUD list page
     */
    private function register_custom_columns()
    {
        add_filter('manage_wp_scratchit_posts_columns', 'custom_columns');
        add_action('manage_wp_scratchit_posts_custom_column', 'custom_content', 10, 2);

        function custom_columns($columns)
        {
            return ['cb' => '<input type="checkbox',
                'title' => __('Title'),
                'short_code' => __('Short Code'),
                'count_scratched' => __('Scratched'),
                'date' => __('Date')
            ];
        }

        function custom_content($column, $post_id)
        {
            global $post;

            if ($column == 'short_code') {
                echo '<p>[wp-scratchit id="' . $post_id . '"] Or <br> [wp-scratchit title="' . $post->post_title . '"]</p>';
            }

            if ($column == 'count_scratched') {
                $data = new User_ScratchIt_Data();
                echo '<p>' . $data->countNumberEntriesByCard($post_id). '</p>';
            }
        }
    }

    private function register_custom_fields()
    {
        add_action('add_meta_boxes', function () {
            /* META BOXES */
            add_meta_box('wp_scratchit_stats', 'Card Stats', 'wp_scratchit_stats_fields', 'wp_scratchit');
            add_meta_box('wp_scratchit', 'ScratchIt Options', 'wp_scratchit_fields', 'wp_scratchit');
            add_meta_box('wp_scratchit_values', __('ScratchIt Cards'), 'wp_scratchit_tab', 'wp_scratchit');
            /* SIDE META BOXES */
            // add_meta_box('wp_scratchit_options', __('Options'), 'wp_scratch_options', 'wp_scratchit', 'side');
        });

        add_action('save_post', [$this, 'save_post']);


        function wp_scratchit_tab($post)
        {
            $cards = get_values(get_the_ID(), 'wp_scratchit_post_cards');

            ?>
            <div class="tab-wrapper wp-scratch-cards">
                <div class="hidden-template">
                    <?php print_template(); ?>
                </div>
    
                <div class="scratch-tab-new">
                    <span class="icon">+</span>
                    <span class="title"><?= __('Add Scratch') ?></span>
                </div>
    
                <div class="tabs">
                    <?php if (!($cards->Count())): ?>
                        <div class="panel-item-bar active-btn-panel" data-id="1">1</div>
                    <?php else: ?>
                        <?php for ($i = 1; $i <= $cards->Count(); $i++): ?>
                            <div class="panel-item-bar <?php echo ($i === 1 ? 'active-btn-panel' : '') ?>" data-id="<?php echo $i ?>"><?php echo $i ?></div>
                        <?php endfor ?>
                    <?php endif ?>
                </div>
    
                <div class="tabs-content">
                <?php if (!($cards->Count())): ?>
                    <div class="tab-content tab-active" data-id="1">
                        <?php print_template(null, 1); ?>
                    </div>
                <?php else: $i = 0; ?>
                    <?php foreach($cards->getItems() as $card):  $i++; ?>
                        <div class="tab-content <?php echo $i === 1 ? 'tab-active'  : ''; ?> " data-id="<?php echo $card->getID(); ?>">
                            <?php print_template($card); ?>
                        </div>
                    <?php endforeach ?>
                <?php endif ?>
                </div>
            </div>
            <?php
        }

        /**
         * @param $post
         */
        function wp_scratchit_fields($post)
        {
            wp_nonce_field(basename(__FILE__), 'wpsrit_nonce');
            $only_once    = get_post_meta($post->ID, 'wp_scratchit_meta_only_once', true);
            $max_winners  = get_post_meta($post->ID, 'wp_scratchit_meta_max_winners', true);
            $foreground   = get_post_meta($post->ID, 'wp_scratchit_meta_foreground', true);
            $width_value  = get_post_meta($post->ID, 'wp_scratchit_meta_width', true);
            $height_value = get_post_meta($post->ID, 'wp_scratchit_meta_height', true);
            $winners = json_decode(get_post_meta($post->ID, WPScratchIt_Posts::$posts_winners_metakey, true));

            if (!is_null($winners))
                $limit_reached = ((int)$max_winners === count($winners));
            // version 1.9
            $expires_on = get_post_meta($post->ID, 'wp_scratchit_meta_expires_on', true);
            $expires_date = get_post_meta($post->ID, 'wp_scratchit_meta_expires_date', true);

            ?>
            <table class="widefat wpscratchit-fields">
                <tbody>
                <tr>
                    <td>
                        <label for="wp_scratch_meta_foreground_image"><?php _e('Foreground', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <input type="text" class="meta-image-upload" id="foreground_in"
                               name="wp_scratch_meta_foreground_image" value="<?= esc_attr($foreground) ?>"/>
                        <input type="button" class="button upload_image_btn"
                               value="<?php _e('Choose or Upload an Image', 'wpsrit_text') ?>"/>
                    </td>
                </tr>
                <tr>
                    <td><label for="wp_scratch_meta_width"><?php _e('Width') ?></label></td>
                    <td><input type="number" name="wp_scratch_meta_width" value="<?= esc_attr($width_value) ?>"/></td>
                </tr>
                <tr>
                    <td><label for="wp_scratch_meta_height"><?php _e('Height') ?></label></td>
                    <td><input type="number" name="wp_scratch_meta_height" value="<?= esc_attr($height_value) ?>"/></td>
                </tr>
                <tr class="max_winners_scratch" style="">
                    <td><label for="wp_scratch_meta_max_winners"><?php _e('Max Winners') ?></label></td>
                    <td><input type="number" name="wp_scratch_meta_max_winners" value="<?php echo ($max_winners) ? $max_winners : 0; ?>"/>
                        <small>0: Means no limit</small>
                    </td>
                </tr>
                <tr>
                    <td><label for="wp_scratch_meta_expire_on"><?php _e('Expires On:') ?></label></td>
                    <td><select class="wp_scratch_expire_on_select" name="wp_scratch_meta_expire_on">
                            <option <?php echo $expires_on == 'all_over' ? 'selected' :'';  ?> value="all_over">After All Winning cards are over</option>
                            <option <?php echo $expires_on == 'date' ? 'selected' :'';  ?> value="date">Date</option>
                            <option <?php echo $expires_on == 'never' ? 'selected' :'';  ?> value="never">Never</option>
                        </select>
                        <input value="<?php echo $expires_date  ?>" class="wp_scratch_expire_on_date" name="wp_scratch_meta_expires_date" type="date" />
                    </td>
                </tr>
                <?php if ($limit_reached && $max_winners != 0): ?>
                <tr>
                    <td><label for="wp_scratch_meta_reset_winners"></label></td>
                    <td><input type="button" value="Reset current winners" data-id="<?= $post->ID; ?>" class="click_reset_winners"></td>
                </tr>
                <?php endif ?>
             <!--   <tr>
                    <td><label for="wp_scratch_meta_only_once"><?php _e('Only once') ?></label></td>
                    <td><input type="checkbox" name="wp_scratch_meta_only_once" value="on" <?php echo ($only_once == 'on') ? 'checked' : ''; ?>/>
                    </td>
                </tr> -->
                </tbody>
            </table>
            <?php
        }

        function wp_scratchit_stats_fields($post)
        {
            $max_winners = get_post_meta($post->ID,'wp_scratchit_meta_max_winners', true);
            if ($max_winners == 0) $max_winners = 'No limit';
            $current_winners = json_decode(get_post_meta($post->ID, WPScratchIt_Posts::$posts_winners_metakey, true));

            if (!is_null($current_winners))
            {
                $current_winners_count = count($current_winners);
                $user_data = new User_ScratchIt_Data();
                $total = $user_data->countNumberEntriesByCard($post->ID);
            }
            else
            {
                $current_winners_count = 0;
                $total = 0;
            }

            ?>
            <table>
                <thead>
                    <tr>
                        <th>Total Wins</th>
                        <th>Total Loses</th>
                        <th>Total of Scratch</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><p><?= "$current_winners_count / $max_winners" ?></p></td>
                        <td><?= $total - $current_winners_count ?></td>
                        <td><?= $total ?></td>
                    </tr>
                </tbody>
            </table>
            <?php
        }

        /**
         * @param Scratch_Card|null $card
         * @param null $id
         */
        function print_template(Scratch_Card $card = null, $id =  null)
        {
            if (is_null($card) && is_null($id))
            {
                $value_name = 'card_ID';
            }
            elseif (!is_null($card) && is_null($id))
            {
                $value_name = 'card_'.$card->getID();
            }
            else
            {
                $value_name = 'card_'.$id;
            }

            ?>
            <table class="widefat">
                <tbody>
                <tr style="display:  none;">
                    <td><input name="wp_scratch_meta[<?= $value_name ?>]" type="hidden"></td>
                </tr>
                <tr>
                    <td>
                        <label for="wp_scratch_meta_text[<?= $value_name ?>]"><?php _e('Text', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <input type="text"
                               name="wp_scratch_meta_text[<?= $value_name ?>]" value="<?php echo ($card) ? $card->getText() : ''; ?>" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <label
                            for="wp_scratch_meta_background[<?= $value_name ?>]"><?php _e('Background URL', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <input type="text"
                               name="wp_scratch_meta_background[<?= $value_name ?>]"  value="<?php echo ($card) ? $card->getBackground() : ''; ?>" />
                        <input type="button" class="button upload_image_btn"
                               value="<?php _e('Choose or Upload an Image', 'wpsrit_text') ?>"/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label
                            for="wp_scratch_meta_font_size[<?= $value_name ?>]"><?php _e('Font Size', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <input type="number" name="wp_scratch_meta_font_size[<?= $value_name ?>]"
                               value="<?php echo ($card) ? $card->getFontSize() : ''; ?>"/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label
                            for="wp_scratch_meta_text_color[<?= $value_name ?>]"><?php _e('Text Color', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <input type="color" name="wp_scratch_meta_text_color[<?= $value_name ?>]"
                               value="<?php echo ($card) ? $card->getTextColor() : ''; ?>"/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label
                            for="wp_scratch_meta_redirect_link[<?= $value_name ?>]"><?php _e('Redirect Link', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <input type="text"
                               name="wp_scratch_meta_redirect_link[<?= $value_name ?>]" value="<?php echo ($card) ? $card->getRedirectLink() : ''; ?>">
                    </td>
                </tr>
                <?php if (class_exists('myCRED_Hook')): ?>
                    <tr>
                        <td>
                            <label
                                for="wp_scratch_meta_mycred_points[<?= $value_name ?>]"><?php _e('MyCred Points', 'wpsrit_text') ?></label>
                        </td>
                        <td>
                            <input type="number"
                                   name="wp_scratch_meta_mycred_points[<?= $value_name ?>]" value="<?php echo ($card) ? $card->getMycredPoints() : ''; ?>">
                        </td>
                    </tr>
                <?php endif ?>
                <tr>
                    <td>
                        <label for="wp_scratch_meta_is_winning_value[<?= $value_name ?>]"><?php _e('Is a Winning Card?', 'wpsrit_text') ?></label>
                    </td>
                    <td>
                        <?php isset($card) ? ($card->getIsWinningValue()): ''; ?>
                        <input type="checkbox"
                               name="wp_scratch_meta_is_winning_value[<?= $value_name ?>]" <?php echo $card ? $card->getIsWinningValue() == 'on' ? 'checked' : '' : '';  ?>>
                    </td>
                </tr>

                </tbody>
            </table>
            <?php
        }

        function get_values($post_id, $key)
        {
            $json = get_post_meta($post_id, $key, true);
            $cards = new Scratch_CardCollection();
            $cards->ParseJson($json);
            return $cards;
        }

    }

    public function save_post($post_id)
    {
        $is_autosave = wp_is_post_autosave($post_id);
        $is_revision = wp_is_post_revision($post_id);
        $is_valid_nonce = (isset($_POST['wpsrit_nonce']) && wp_verify_nonce($_POST['wpsrit_nonce'], basename(__FILE__))) ? true : false;
        $options     = get_option('wp_scratchit_options');

        if ($is_autosave || $is_revision || !$is_valid_nonce)
            return;

        if (!current_user_can('edit_post', $post_id))
            return;

       // delete_post_meta($post_id, static::$cards_meta_key );

        /***  GENERAL SCRATCH OPTIONS  ***/

        $options['textcolor'] = (isset($_POST['wp_scratch_meta_textcolor']) ? (preg_match('/^#[a-f0-9]{6}$/i', $_POST['wp_scratch_meta_textcolor']) ? $_POST['wp_scratch_meta_textcolor'] : ''): '');
		$options['foreground_image'] = (isset($_POST['wp_scratch_meta_foreground_image']) ? (filter_var($_POST['wp_scratch_meta_foreground_image'], FILTER_VALIDATE_URL) ? $_POST['wp_scratch_meta_foreground_image'] : '') : '');
		$options['width'] = (isset($_POST['wp_scratch_meta_width']) ? (filter_var($_POST['wp_scratch_meta_width'], FILTER_VALIDATE_INT) ? $_POST['wp_scratch_meta_width'] : '') : '');
		$options['height'] = (isset($_POST['wp_scratch_meta_height']) ? (filter_var($_POST['wp_scratch_meta_height'], FILTER_VALIDATE_INT) ? $_POST['wp_scratch_meta_height']: '') : '');
        $options['max_winners'] = (isset($_POST['wp_scratch_meta_max_winners']) ? filter_var($_POST['wp_scratch_meta_max_winners'], FILTER_VALIDATE_INT) : '');
       //  $options['limit_winners'] = (isset($_POST['wp_scratch_meta_limit_winners']) ? sanitize_text_field($_POST['wp_scratch_meta_limit_winners']) : '');
        $options['only_once'] = (isset($_POST['wp_scratch_meta_only_once']) ? sanitize_text_field($_POST['wp_scratch_meta_only_once']) : '');
        $options['expires_on'] = (isset($_POST['wp_scratch_meta_expire_on']) ? sanitize_text_field($_POST['wp_scratch_meta_expire_on']) : '' );
        $options['expires_date'] = (isset($_POST['wp_scratch_meta_expires_date']) ? sanitize_text_field($_POST['wp_scratch_meta_expires_date']): '');

        update_post_meta($post_id, 'wp_scratchit_meta_only_once', $options['only_once']);
       //  update_post_meta($post_id, 'wp_scratchit_meta_limit_winners', $options['limit_winners']);
        update_post_meta($post_id, 'wp_scratchit_meta_max_winners', $options['max_winners']);
        update_post_meta($post_id, 'wp_scratchit_meta_foreground', $options['foreground_image']);
        update_post_meta($post_id, 'wp_scratchit_meta_width', $options['width']);
        update_post_meta($post_id, 'wp_scratchit_meta_height', $options['height']);

        // version 1.9
        update_post_meta($post_id, 'wp_scratchit_meta_expires_on', $options['expires_on']);
        update_post_meta($post_id, 'wp_scratchit_meta_expires_date', $options['expires_date']);

        /*** END GENERAL SCRATCH OPTIONS ***/

        $post_content = '';
        if (isset($_POST['post_content'])) $post_content = filter_var(trim(preg_replace('!&nbsp;!', '', $_POST['post_content'])), FILTER_SANITIZE_STRING);
        $sizes = $this->get_sizes($post_id, $options);
        $width = $sizes[0];
        $height = $sizes[1];

        $basepath = '/wp-scratchit/content/post_'.$post_id;
        $path = wp_upload_dir()['basedir']. $basepath;
        wp_mkdir_p( $path );

        // Set Height & Width Globally
        Scratch_Card::setHeight($height);
        Scratch_Card::setWidth($width);

        Scratch_Card::setPostContent($post_content);
        Scratch_Card::setBasePath($basepath);

        $keys = array(
                'wp_scratch_meta_text',
                'wp_scratch_meta_text_color',
                'wp_scratch_meta_background',
                'wp_scratch_meta_font_size',
                'wp_scratch_meta_redirect_link',
                'wp_scratch_meta_mycred_points',
                'wp_scratch_meta_is_winning_value',
            );

        $cards = [];
        $empty = true;
        foreach($keys as $key) {
            if (isset($_POST[$key]) && !empty($_POST[$key])) {
                foreach($_POST[$key] as $subkey =>  $item) {
                    if ($subkey !== 'card_ID')
                    {
                        if (($key == 'wp_scratch_meta_background' || $key == 'wp_scratch_meta_text')
                            && !empty($item))
                        {
                            $empty = false;
                        }

                        $pos = explode('_', $subkey);
                        $pos = intval($pos[1]);
                        $cards[$pos][PostKeyDecorator::to($key)] = $item;
                    }
                }
            }
        }

        if (!$empty)
        {
            $CardsCollection = new Scratch_CardCollection();
            $CardsCollection->AddFromArray($cards); // All Entry Will be verified before it get accepted
            $CardsCollection->startGeneratingImages(); // Start Generating Images
            // Save Meta
            update_post_meta( $post_id, static::$cards_meta_key , $CardsCollection->toJson() );
        }
    }

    private function get_sizes($post_id, $options)
    {
       // if (intval($_POST['wp_scratch_meta_scratch_type']) === 2 || (intval($_POST['wp_scratch_meta_scratch_type']) === 0 && $options['wp_scratchit_scratch_type'] === 'color'))
       //  {
            $width  = !empty($_POST['wp_scratch_meta_width']) ? $_POST['wp_scratch_meta_width'] : 400;
            $height = !empty($_POST['wp_scratch_meta_height']) ? $_POST['wp_scratch_meta_height'] : 400;
        //}
        // else
        if (isset($options['wp_scratchit_background'])) {
            $sizes = getimagesize($options['wp_scratchit_background']);
            $width  = $sizes[0];
            $height = $sizes[1];

            // delete post_meta_width, post_meta_height
            delete_post_meta($post_id, 'wp_scratchit_meta_width');
            delete_post_meta($post_id, 'wp_scratchit_meta_height');
        }

        return [$width, $height];
    }
}