<?php

/**
 * @link              
 * @since             1.2.0
 * @package           WP ScratchIt
 *
 * @wordpress-plugin
 * Plugin Name:       WordPress ScratchIt
 * Plugin URI:        http://wpscratchit.devplus31.com/
 * Author URI:   	  http://devplus31.com/
 * Description:       WP ScratchIt is a WordPress Plugin designed to provide interactive scratch cards by generating them. the plugin is optimized for all Modern browsers, because it uses the latest HTML5 and CSS3 technology to provide a better experience of scratching. You can use the plugin to make scratch cards, promotional code, coupons or even advertisements.
 * Version:           1.9.2
 * Author:            DevPlus31
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

function activate_plugin_name() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wpscratch-activator.php';
	WPScratch_Activator::activate();
}


function deactivate_plugin_name() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wpscratch-deactivator.php';
	WPScratch_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_plugin_name' );
register_deactivation_hook( __FILE__, 'deactivate_plugin_name' );

require plugin_dir_path( __FILE__ ) . 'includes/class-wpscratch.php';

function run_plugin_name() {

	$plugin = new WPScratch();
	$plugin->run();

}
run_plugin_name();